/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.content.Context;
import android.view.OrientationEventListener;

public class SensorRotationManager {
    private final OrientationEventListener listener;
    private int currentOrientation = -1;

    public SensorRotationManager(Context context, final boolean avoidDuplicated, final RotationChangedListener rotationListener) {
        this.listener = new OrientationEventListener(context, 3){

            public void onOrientationChanged(int sensorOrientation) {
                int rotation = (sensorOrientation + 45) / 90 % 4;
                int rotationDegrees = rotation * 90;
                if (avoidDuplicated) {
                    if (SensorRotationManager.this.currentOrientation == rotationDegrees) {
                        return;
                    }
                    SensorRotationManager.this.currentOrientation = rotationDegrees;
                }
                rotationListener.onRotationChanged(rotationDegrees);
            }
        };
    }

    public void start() {
        if (this.listener.canDetectOrientation()) {
            this.currentOrientation = -1;
            this.listener.enable();
        }
    }

    public void stop() {
        this.listener.disable();
        this.currentOrientation = -1;
    }

    public static interface RotationChangedListener {
        public void onRotationChanged(int var1);
    }
}

