/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.library.base.FromFileBase;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtsp.rtsp.RtspClient;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public class RtspFromFile
extends FromFileBase {
    private final RtspClient rtspClient;
    private final RtspStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    public RtspFromFile(ConnectChecker connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspFromFile(Context context, ConnectChecker connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspFromFile(OpenGlView openGlView, ConnectChecker connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspFromFile(LightOpenGlView lightOpenGlView, ConnectChecker connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(lightOpenGlView, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    @Override
    public RtspStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setVideoCodecImp(VideoCodec codec) {
        this.rtspClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        this.rtspClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.setOnlyAudio(!this.videoEnabled);
        this.rtspClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtspClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }
}

