/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.content.Context;
import android.view.OrientationEventListener;

public class SensorRotationManager {
    private final OrientationEventListener listener;

    public SensorRotationManager(Context context, final RotationChangedListener rotationListener) {
        this.listener = new OrientationEventListener(context, 3){

            public void onOrientationChanged(int sensorOrientation) {
                int rotation = (sensorOrientation + 45) / 90 % 4;
                int rotationDegrees = rotation * 90;
                rotationListener.onRotationChanged(rotationDegrees);
            }
        };
    }

    public void start() {
        if (this.listener.canDetectOrientation()) {
            this.listener.enable();
        }
    }

    public void stop() {
        this.listener.disable();
    }

    public static interface RotationChangedListener {
        public void onRotationChanged(int var1);
    }
}

