/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.library.base.FromFileBase;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.srt.srt.SrtClient;
import com.pedro.srt.srt.VideoCodec;
import com.pedro.srt.utils.ConnectCheckerSrt;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public class SrtFromFile
extends FromFileBase {
    private final SrtClient srtClient;
    private final SrtStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    public SrtFromFile(ConnectCheckerSrt connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(videoDecoderInterface, audioDecoderInterface);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    public SrtFromFile(Context context, ConnectCheckerSrt connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    public SrtFromFile(OpenGlView openGlView, ConnectCheckerSrt connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    public SrtFromFile(LightOpenGlView lightOpenGlView, ConnectCheckerSrt connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(lightOpenGlView, videoDecoderInterface, audioDecoderInterface);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.recordController.setVideoMime(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.srtClient.setVideoCodec(videoCodec);
    }

    public SrtStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.srtClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.srtClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendAudio(aacBuffer, info);
    }
}

