/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.Camera1Base;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.srt.srt.SrtClient;
import com.pedro.srt.srt.VideoCodec;
import com.pedro.srt.utils.ConnectCheckerSrt;
import java.nio.ByteBuffer;

public class SrtCamera1
extends Camera1Base {
    private final SrtClient srtClient;
    private final SrtStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    public SrtCamera1(SurfaceView surfaceView, ConnectCheckerSrt connectChecker) {
        super(surfaceView);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    public SrtCamera1(TextureView textureView, ConnectCheckerSrt connectChecker) {
        super(textureView);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    @RequiresApi(api=18)
    public SrtCamera1(OpenGlView openGlView, ConnectCheckerSrt connectChecker) {
        super(openGlView);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    @RequiresApi(api=18)
    public SrtCamera1(LightOpenGlView lightOpenGlView, ConnectCheckerSrt connectChecker) {
        super(lightOpenGlView);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    @RequiresApi(api=18)
    public SrtCamera1(Context context, ConnectCheckerSrt connectChecker) {
        super(context);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    public SrtStreamClient getStreamClient() {
        return this.streamClient;
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.recordController.setVideoMime(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.srtClient.setVideoCodec(videoCodec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.srtClient.setOnlyVideo(!this.audioInitialized);
        this.srtClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.srtClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendVideo(h264Buffer, info);
    }
}

