/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.Camera2Base;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.rtsp.VideoCodec;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class RtspCamera2
extends Camera2Base {
    private final RtspClient rtspClient;
    private final RtspStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    @Deprecated
    public RtspCamera2(SurfaceView surfaceView, ConnectCheckerRtsp connectCheckerRtsp) {
        super(surfaceView);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    @Deprecated
    public RtspCamera2(TextureView textureView, ConnectCheckerRtsp connectCheckerRtsp) {
        super(textureView);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspCamera2(OpenGlView openGlView, ConnectCheckerRtsp connectCheckerRtsp) {
        super(openGlView);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspCamera2(LightOpenGlView lightOpenGlView, ConnectCheckerRtsp connectCheckerRtsp) {
        super(lightOpenGlView);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspCamera2(Context context, boolean useOpengl, ConnectCheckerRtsp connectCheckerRtsp) {
        super(context, useOpengl);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspStreamClient getStreamClient() {
        return this.streamClient;
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.recordController.setVideoMime(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.setOnlyVideo(!this.audioInitialized);
        this.rtspClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtspClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendVideo(h264Buffer, info);
    }
}

