/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.Camera2Base;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtmp.rtmp.VideoCodec;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class RtmpCamera2
extends Camera2Base {
    private final RtmpClient rtmpClient;
    private final RtmpStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    @Deprecated
    public RtmpCamera2(SurfaceView surfaceView, ConnectCheckerRtmp connectChecker) {
        super(surfaceView);
        this.rtmpClient = new RtmpClient(connectChecker);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, this.streamClientListener);
    }

    @Deprecated
    public RtmpCamera2(TextureView textureView, ConnectCheckerRtmp connectChecker) {
        super(textureView);
        this.rtmpClient = new RtmpClient(connectChecker);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, this.streamClientListener);
    }

    public RtmpCamera2(OpenGlView openGlView, ConnectCheckerRtmp connectChecker) {
        super(openGlView);
        this.rtmpClient = new RtmpClient(connectChecker);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, this.streamClientListener);
    }

    public RtmpCamera2(LightOpenGlView lightOpenGlView, ConnectCheckerRtmp connectChecker) {
        super(lightOpenGlView);
        this.rtmpClient = new RtmpClient(connectChecker);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, this.streamClientListener);
    }

    public RtmpCamera2(Context context, boolean useOpengl, ConnectCheckerRtmp connectChecker) {
        super(context, useOpengl);
        this.rtmpClient = new RtmpClient(connectChecker);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, this.streamClientListener);
    }

    public RtmpStreamClient getStreamClient() {
        return this.streamClient;
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.recordController.setVideoMime(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.rtmpClient.setVideoCodec(videoCodec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.rtmpClient.setFps(this.videoEncoder.getFps());
        this.rtmpClient.setOnlyVideo(!this.audioInitialized);
        this.rtmpClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtmpClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendVideo(h264Buffer, info);
    }
}

