/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class AacMuxerRecordController
extends BaseRecordController {
    private static final String TAG = "AacMuxRecordController";
    private OutputStream outputStream;
    private final Integer[] AudioSampleRates = new Integer[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};
    private int sampleRate = -1;
    private int channels = -1;

    @Override
    @RequiresApi(api=18)
    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.outputStream = new FileOutputStream(path);
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            listener.onStatusChange(this.status);
        }
        if (this.sampleRate != -1 && this.channels != -1) {
            this.init();
        }
    }

    @Override
    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        throw new IOException("FileDescriptor unsupported");
    }

    @Override
    @RequiresApi(api=18)
    public void stopRecord() {
        this.status = RecordController.Status.STOPPED;
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        this.sampleRate = -1;
        this.channels = -1;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @Override
    @RequiresApi(api=18)
    public void recordVideo(ByteBuffer videoBuffer, MediaCodec.BufferInfo videoInfo) {
    }

    @Override
    @RequiresApi(api=18)
    public void recordAudio(ByteBuffer audioBuffer, MediaCodec.BufferInfo audioInfo) {
        if (this.status == RecordController.Status.RECORDING) {
            Log.i((String)TAG, (String)("s: " + this.sampleRate + ", c: " + this.channels));
            this.updateFormat(this.audioInfo, audioInfo);
            this.write(audioBuffer, this.audioInfo);
        }
    }

    @Override
    public void setVideoFormat(MediaFormat videoFormat, boolean isOnlyVideo) {
    }

    @Override
    public void setAudioFormat(MediaFormat audioFormat, boolean isOnlyAudio) {
        this.sampleRate = audioFormat.getInteger("sample-rate");
        this.channels = audioFormat.getInteger("channel-count");
        if (this.status == RecordController.Status.STARTED && Build.VERSION.SDK_INT >= 18) {
            this.init();
        }
    }

    @Override
    public void resetFormats() {
    }

    @RequiresApi(api=18)
    private void init() {
        this.status = RecordController.Status.RECORDING;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @RequiresApi(api=18)
    private void write(ByteBuffer byteBuffer, MediaCodec.BufferInfo info) {
        try {
            if ((info.flags & 2) != 2) {
                byte[] header = this.createAdtsHeader(info.size - info.offset);
                this.outputStream.write(header);
                byte[] data = new byte[byteBuffer.remaining()];
                byteBuffer.get(data);
                this.outputStream.write(data);
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            Log.i((String)TAG, (String)"Write error", (Throwable)e);
        }
    }

    private byte[] createAdtsHeader(int length) {
        int frameLength = length + 7;
        byte[] adtsHeader = new byte[7];
        int sampleRateIndex = Arrays.asList(this.AudioSampleRates).indexOf(this.sampleRate);
        adtsHeader[0] = -1;
        adtsHeader[1] = -15;
        adtsHeader[2] = 64;
        adtsHeader[2] = (byte)(adtsHeader[2] | (byte)sampleRateIndex << 2);
        adtsHeader[2] = (byte)(adtsHeader[2] | (byte)this.channels >> 2);
        adtsHeader[3] = (byte)((this.channels & 3) << 6 | frameLength >> 11 & 3);
        adtsHeader[4] = (byte)(frameLength >> 3 & 0xFF);
        adtsHeader[5] = (byte)((frameLength & 7) << 5 | 0x1F);
        adtsHeader[6] = -4;
        return adtsHeader;
    }
}

