/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.StreamBase;
import com.pedro.library.util.sources.AudioManager;
import com.pedro.library.util.sources.VideoManager;
import com.pedro.srt.srt.SrtClient;
import com.pedro.srt.srt.VideoCodec;
import com.pedro.srt.utils.ConnectCheckerSrt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\"\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010\u0016H\u0014J\u001a\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0014J\b\u0010*\u001a\u00020\u000fH\u0016J\b\u0010+\u001a\u00020\u000fH\u0016J\b\u0010,\u001a\u00020\u000fH\u0016J\b\u0010-\u001a\u00020\u000fH\u0016J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u0011H\u0016J\u0010\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020)H\u0014J\b\u00102\u001a\u00020\u000fH\u0014J\u001c\u00103\u001a\u00020\u000f2\b\u00104\u001a\u0004\u0018\u00010)2\b\u00105\u001a\u0004\u0018\u00010)H\u0014J\u0010\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u0013H\u0016J\u0010\u00108\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u0013H\u0016J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u0011H\u0016J\u000e\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020=J\u0010\u0010>\u001a\u00020\u00132\u0006\u0010?\u001a\u00020)H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/pedro/library/srt/SrtStream;", "Lcom/pedro/library/base/StreamBase;", "context", "Landroid/content/Context;", "connectCheckerRtmp", "Lcom/pedro/srt/utils/ConnectCheckerSrt;", "(Landroid/content/Context;Lcom/pedro/srt/utils/ConnectCheckerSrt;)V", "videoSource", "Lcom/pedro/library/util/sources/VideoManager$Source;", "audioSource", "Lcom/pedro/library/util/sources/AudioManager$Source;", "(Landroid/content/Context;Lcom/pedro/srt/utils/ConnectCheckerSrt;Lcom/pedro/library/util/sources/VideoManager$Source;Lcom/pedro/library/util/sources/AudioManager$Source;)V", "srtClient", "Lcom/pedro/srt/srt/SrtClient;", "audioInfo", "", "sampleRate", "", "isStereo", "", "getAacDataRtp", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getCacheSize", "getDroppedAudioFrames", "", "getDroppedVideoFrames", "getH264DataRtp", "h264Buffer", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "onSpsPpsVpsRtp", "sps", "pps", "vps", "reConnect", "delay", "backupUrl", "", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "rtpStartStream", "endPoint", "rtpStopStream", "setAuthorization", "user", "password", "setCheckServerAlive", "enabled", "setLogs", "setReTries", "reTries", "setVideoCodec", "videoCodec", "Lcom/pedro/srt/srt/VideoCodec;", "shouldRetry", "reason", "library_release"})
@RequiresApi(value=21)
public final class SrtStream
extends StreamBase {
    @NotNull
    private final SrtClient srtClient;

    public SrtStream(@NotNull Context context, @NotNull ConnectCheckerSrt connectCheckerRtmp, @NotNull VideoManager.Source videoSource, @NotNull AudioManager.Source audioSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtmp, (String)"connectCheckerRtmp");
        Intrinsics.checkNotNullParameter((Object)((Object)videoSource), (String)"videoSource");
        Intrinsics.checkNotNullParameter((Object)((Object)audioSource), (String)"audioSource");
        super(context, videoSource, audioSource);
        this.srtClient = new SrtClient(connectCheckerRtmp);
    }

    public SrtStream(@NotNull Context context, @NotNull ConnectCheckerSrt connectCheckerRtmp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtmp, (String)"connectCheckerRtmp");
        this(context, connectCheckerRtmp, VideoManager.Source.CAMERA2, AudioManager.Source.MICROPHONE);
    }

    public final void setVideoCodec(@NotNull VideoCodec videoCodec) {
        Intrinsics.checkNotNullParameter((Object)videoCodec, (String)"videoCodec");
        String mime = videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc";
        super.setVideoMime(mime);
        this.srtClient.setVideoCodec(videoCodec);
    }

    @Override
    protected void audioInfo(int sampleRate, boolean isStereo) {
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void rtpStartStream(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        SrtClient.connect$default((SrtClient)this.srtClient, (String)endPoint, (boolean)false, (int)2, null);
    }

    @Override
    protected void rtpStopStream() {
        this.srtClient.disconnect();
    }

    @Override
    protected void setAuthorization(@Nullable String user, @Nullable String password) {
        this.srtClient.setAuthorization(user, password);
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.srtClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.srtClient.sendAudio(aacBuffer, info);
    }

    @Override
    public void setReTries(int reTries) {
        this.srtClient.setReTries(reTries);
    }

    @Override
    protected boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return this.srtClient.shouldRetry(reason);
    }

    @Override
    protected void reConnect(long delay, @Nullable String backupUrl) {
        this.srtClient.reConnect(delay, backupUrl);
    }

    @Override
    public boolean hasCongestion() {
        return this.srtClient.hasCongestion();
    }

    @Override
    public void setLogs(boolean enabled) {
        this.srtClient.setLogs(enabled);
    }

    @Override
    public void setCheckServerAlive(boolean enabled) {
        this.srtClient.setCheckServerAlive(enabled);
    }

    @Override
    public void resizeCache(int newSize) {
        this.srtClient.resizeCache(newSize);
    }

    @Override
    public int getCacheSize() {
        return this.srtClient.getCacheSize();
    }

    @Override
    public long getSentAudioFrames() {
        return this.srtClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.srtClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.srtClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.srtClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.srtClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.srtClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.srtClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.srtClient.resetDroppedVideoFrames();
    }
}

