/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.extrasources.extractor;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import androidx.core.content.FileProvider;
import androidx.media3.exoplayer.MediaExtractorCompat;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.encoder.input.decoder.AudioInfo;
import com.pedro.encoder.input.decoder.Extractor;
import com.pedro.encoder.input.decoder.VideoInfo;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\tH\u0016J\b\u0010%\u001a\u00020\u0014H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010+\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/pedro/extrasources/extractor/Media3Extractor;", "Lcom/pedro/encoder/input/decoder/Extractor;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mediaExtractor", "Landroidx/media3/exoplayer/MediaExtractorCompat;", "sleepTime", "", "accumulativeTs", "lastExtractorTs", "format", "Landroid/media/MediaFormat;", "duration", "selectTrack", "", "type", "Lcom/pedro/common/frame/MediaFrame$Type;", "initialize", "", "path", "uri", "Landroid/net/Uri;", "fileDescriptor", "Ljava/io/FileDescriptor;", "readFrame", "", "buffer", "Ljava/nio/ByteBuffer;", "advance", "", "getTimeStamp", "getSleepTime", "ts", "seekTo", "time", "release", "getVideoInfo", "Lcom/pedro/encoder/input/decoder/VideoInfo;", "getAudioInfo", "Lcom/pedro/encoder/input/decoder/AudioInfo;", "getFormat", "reset", "extra-sources_release"})
@SuppressLint(value={"UnsafeOptInUsageError"})
@SourceDebugExtension(value={"SMAP\nMedia3Extractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Media3Extractor.kt\ncom/pedro/extrasources/extractor/Media3Extractor\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,158:1\n29#2:159\n*S KotlinDebug\n*F\n+ 1 Media3Extractor.kt\ncom/pedro/extrasources/extractor/Media3Extractor\n*L\n68#1:159\n*E\n"})
public final class Media3Extractor
implements Extractor {
    @NotNull
    private final Context context;
    @NotNull
    private MediaExtractorCompat mediaExtractor;
    private long sleepTime;
    private long accumulativeTs;
    private volatile long lastExtractorTs;
    @Nullable
    private MediaFormat format;
    private long duration;

    public Media3Extractor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mediaExtractor = new MediaExtractorCompat(this.context);
        this.duration = -1L;
    }

    @NotNull
    public String selectTrack(@NotNull MediaFrame.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.selectTrack("video/");
            case 2 -> this.selectTrack("audio/");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public void initialize(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String $this$toUri$iv = path;
        boolean $i$f$toUri = false;
        this.initialize(this.context, Uri.parse((String)$this$toUri$iv));
    }

    public void initialize(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            this.reset();
            MediaMetadataRetriever metadata = new MediaMetadataRetriever();
            metadata.setDataSource(context, uri);
            String duration = metadata.extractMetadata(9);
            Object object = duration;
            this.duration = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object * (long)1000 : 0L;
            this.mediaExtractor = new MediaExtractorCompat(context);
            this.mediaExtractor.setDataSource(uri, 0L);
        }
        catch (Exception e) {
            throw new IOException(ExtensionsKt.validMessage((Throwable)e));
        }
    }

    public void initialize(@NotNull FileDescriptor fileDescriptor) {
        Intrinsics.checkNotNullParameter((Object)fileDescriptor, (String)"fileDescriptor");
        try {
            File file = new File(fileDescriptor.toString());
            Uri uri = FileProvider.getUriForFile((Context)this.context, (String)(this.context.getPackageName() + ".fileprovider"), (File)file);
            Intrinsics.checkNotNull((Object)uri);
            this.initialize(this.context, uri);
        }
        catch (Exception e) {
            throw new IOException(ExtensionsKt.validMessage((Throwable)e));
        }
    }

    public int readFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.mediaExtractor.readSampleData(buffer, 0);
    }

    public boolean advance() {
        return this.mediaExtractor.advance();
    }

    public long getTimeStamp() {
        long l;
        try {
            l = this.mediaExtractor.getSampleTime();
        }
        catch (Exception e) {
            l = 0L;
        }
        return l;
    }

    public long getSleepTime(long ts) {
        long extractorTs = Math.max(0L, this.getTimeStamp());
        if (extractorTs == 0L) {
            this.lastExtractorTs = 0L;
        }
        this.accumulativeTs += extractorTs - this.lastExtractorTs;
        this.lastExtractorTs = extractorTs;
        this.sleepTime = this.accumulativeTs > ts ? (this.accumulativeTs - ts) / (long)1000 : 0L;
        return this.sleepTime;
    }

    public void seekTo(long time) {
        this.mediaExtractor.seekTo(time, 0);
        this.lastExtractorTs = this.getTimeStamp();
    }

    public void release() {
        this.mediaExtractor.release();
    }

    @NotNull
    public VideoInfo getVideoInfo() {
        MediaFormat mediaFormat = this.format;
        if (mediaFormat == null) {
            throw new IOException("Extractor track not selected");
        }
        MediaFormat format = mediaFormat;
        Integer n = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"width");
        if (n == null) {
            throw new IOException("Width info is required");
        }
        int width = n;
        Integer n2 = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"height");
        if (n2 == null) {
            throw new IOException("Height info is required");
        }
        int height = n2;
        Integer n3 = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"frame-rate");
        int fps = n3 != null ? n3 : 30;
        return new VideoInfo(width, height, fps, this.duration);
    }

    @NotNull
    public AudioInfo getAudioInfo() {
        MediaFormat mediaFormat = this.format;
        if (mediaFormat == null) {
            throw new IOException("Extractor track not selected");
        }
        MediaFormat format = mediaFormat;
        Integer n = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"sample-rate");
        if (n == null) {
            throw new IOException("Channels info is required");
        }
        int sampleRate = n;
        Integer n2 = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"channel-count");
        if (n2 == null) {
            throw new IOException("SampleRate info is required");
        }
        int channels = n2;
        return new AudioInfo(sampleRate, channels, this.duration);
    }

    @NotNull
    public MediaFormat getFormat() {
        MediaFormat mediaFormat = this.format;
        if (mediaFormat == null) {
            throw new IOException("Extractor track not selected");
        }
        return mediaFormat;
    }

    private final String selectTrack(String type) {
        int n = this.mediaExtractor.getTrackCount();
        for (int i = 0; i < n; ++i) {
            String mime;
            MediaFormat format;
            Intrinsics.checkNotNullExpressionValue((Object)this.mediaExtractor.getTrackFormat(i), (String)"getTrackFormat(...)");
            if (format.getString("mime") == null || !StringsKt.startsWith((String)mime, (String)type, (boolean)true)) continue;
            this.mediaExtractor.selectTrack(i);
            this.format = format;
            return mime;
        }
        throw new IOException("track not found");
    }

    private final void reset() {
        this.duration = -1L;
        this.sleepTime = 0L;
        this.accumulativeTs = 0L;
        this.lastExtractorTs = 0L;
        this.format = null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaFrame.Type.values().length];
            try {
                nArray[MediaFrame.Type.VIDEO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaFrame.Type.AUDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

