/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.extrasources;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.OptIn;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.RenderersFactory;
import com.pedro.common.TimeUtils;
import com.pedro.common.frame.MediaFrame;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioInfo;
import com.pedro.encoder.input.sources.audio.AudioSource;
import com.pedro.extrasources.AudioBufferProcessor;
import com.pedro.extrasources.TracksRenderersFactory;
import com.pedro.extrasources.extractor.Media3Extractor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\b\u0010\u001a\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/pedro/extrasources/Media3AudioSource;", "Lcom/pedro/encoder/input/sources/audio/AudioSource;", "context", "Landroid/content/Context;", "path", "Landroid/net/Uri;", "<init>", "(Landroid/content/Context;Landroid/net/Uri;)V", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "processor", "Lcom/pedro/extrasources/AudioBufferProcessor;", "create", "", "sampleRate", "", "isStereo", "echoCanceler", "noiseSuppressor", "start", "", "getMicrophoneData", "Lcom/pedro/encoder/input/audio/GetMicrophoneData;", "stop", "release", "isRunning", "getPlayer", "extra-sources_release"})
@OptIn(markerClass={UnstableApi.class})
public final class Media3AudioSource
extends AudioSource {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri path;
    @Nullable
    private ExoPlayer player;
    @NotNull
    private final AudioBufferProcessor processor;

    public Media3AudioSource(@NotNull Context context, @NotNull Uri path) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.context = context;
        this.path = path;
        this.processor = new AudioBufferProcessor((Function1<? super byte[], Unit>)((Function1)arg_0 -> Media3AudioSource.processor$lambda$0(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean create(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        void exoPlayer;
        ExoPlayer exoPlayer2;
        Media3Extractor mediaExtractor = new Media3Extractor(this.context);
        try {
            mediaExtractor.initialize(this.context, this.path);
            mediaExtractor.selectTrack(MediaFrame.Type.AUDIO);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Audio file track not found");
        }
        AudioInfo audioInfo = mediaExtractor.getAudioInfo();
        if (audioInfo.getSampleRate() != sampleRate) {
            throw new IllegalArgumentException("Audio file sample rate (" + audioInfo.getSampleRate() + ") is different than the configured: " + sampleRate);
        }
        if (audioInfo.getChannels() > 1 != isStereo) {
            throw new IllegalArgumentException("Audio file isStereo (" + (audioInfo.getChannels() > 1) + ") is different than the configured: " + isStereo);
        }
        mediaExtractor.release();
        ExoPlayer exoPlayer3 = exoPlayer2 = new ExoPlayer.Builder(this.context, (RenderersFactory)new TracksRenderersFactory(this.context, MediaFrame.Type.AUDIO, this.processor)).build();
        Media3AudioSource media3AudioSource = this;
        boolean bl = false;
        MediaItem mediaItem = MediaItem.fromUri((Uri)this.path);
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"fromUri(...)");
        MediaItem mediaItem2 = mediaItem;
        exoPlayer.setMediaItem(mediaItem2);
        exoPlayer.prepare();
        exoPlayer.setRepeatMode(2);
        media3AudioSource.player = exoPlayer2;
        return true;
    }

    public void start(@NotNull GetMicrophoneData getMicrophoneData) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)getMicrophoneData, (String)"getMicrophoneData");
            this.setGetMicrophoneData(getMicrophoneData);
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.play();
        }
    }

    public void stop() {
        this.setGetMicrophoneData(null);
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.release();
        }
        this.player = null;
    }

    public void release() {
    }

    public boolean isRunning() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? exoPlayer.isPlaying() : false;
    }

    @Nullable
    public final ExoPlayer getPlayer() {
        return this.player;
    }

    private static final Unit processor$lambda$0(Media3AudioSource this$0, byte[] bytes) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Frame frame = new Frame(bytes, 0, bytes.length, TimeUtils.getCurrentTimeMicro());
            GetMicrophoneData getMicrophoneData = this$0.getGetMicrophoneData();
            if (getMicrophoneData == null) break block0;
            getMicrophoneData.inputPCMData(frame);
        }
        return Unit.INSTANCE;
    }
}

