/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.RequiresApi;
import com.pedro.common.TimeUtils;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@RequiresApi(api=18)
public class SnowFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uTimeHandle = -1;
    private int uLayersHandle = -1;
    private int uDepthHandle = -1;
    private int uWidthHandle = -1;
    private int uSpeedHandle = -1;
    private final long START_TIME = TimeUtils.getCurrentTimeMillis();
    private float layers = 5.0f;
    private float depth = 0.5f;
    private float width = 0.6f;
    private float speed = 0.6f;

    public SnowFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.snow_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uTimeHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uTime");
        this.uLayersHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uLayers");
        this.uDepthHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uDepth");
        this.uWidthHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uWidth");
        this.uSpeedHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSpeed");
    }

    @Override
    protected void drawFilter() {
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        float time = (float)(TimeUtils.getCurrentTimeMillis() - this.START_TIME) / 1000.0f;
        GLES20.glUniform1f((int)this.uTimeHandle, (float)time);
        GLES20.glUniform1f((int)this.uLayersHandle, (float)this.layers);
        GLES20.glUniform1f((int)this.uDepthHandle, (float)this.depth);
        GLES20.glUniform1f((int)this.uWidthHandle, (float)this.width);
        GLES20.glUniform1f((int)this.uSpeedHandle, (float)this.speed);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
    }

    @Override
    protected void disableResources() {
        GlUtil.disableResources(this.aTextureHandle, this.aPositionHandle);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }

    public void setSpeed(float value) {
        this.speed = value;
    }

    public void setDepth(float depth) {
        this.depth = depth;
    }

    public void setLayers(float layers) {
        this.layers = layers;
    }

    public void setSnowWidth(float width) {
        this.width = width;
    }
}

