/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RequiresApi(api=18)
public class DuotoneFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uColorHandle = -1;
    private int uColor2Handle = -1;
    private static final String HEX_PATTERN = "^#([A-Fa-f0-9]{6})$";
    private float red = 0.0f;
    private float green = 1.0f;
    private float blue = 0.0f;
    private float red2 = 0.0f;
    private float green2 = 0.0f;
    private float blue2 = 1.0f;

    public DuotoneFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.duotone_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uColorHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uColor");
        this.uColor2Handle = GLES20.glGetUniformLocation((int)this.program, (String)"uColor2");
    }

    @Override
    protected void drawFilter() {
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform3f((int)this.uColorHandle, (float)this.red, (float)this.green, (float)this.blue);
        GLES20.glUniform3f((int)this.uColor2Handle, (float)this.red2, (float)this.green2, (float)this.blue2);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
    }

    @Override
    protected void disableResources() {
        GlUtil.disableResources(this.aTextureHandle, this.aPositionHandle);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getRed2() {
        return this.red2;
    }

    public float getGreen2() {
        return this.green2;
    }

    public float getBlue2() {
        return this.blue2;
    }

    public void setRGBColor(String rgbHexColor, String rgbHexColor2) {
        Pattern pattern = Pattern.compile(HEX_PATTERN);
        Matcher matcher = pattern.matcher(rgbHexColor);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid hexColor pattern (Should be: ^#([A-Fa-f0-9]{6})$)");
        }
        int r = Integer.valueOf(rgbHexColor.substring(1, 3), 16);
        int g = Integer.valueOf(rgbHexColor.substring(3, 5), 16);
        int b = Integer.valueOf(rgbHexColor.substring(5, 7), 16);
        this.red = (float)r / 255.0f;
        this.green = (float)g / 255.0f;
        this.blue = (float)b / 255.0f;
        matcher = pattern.matcher(rgbHexColor2);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid hexColor pattern (Should be: ^#([A-Fa-f0-9]{6})$)");
        }
        r = Integer.valueOf(rgbHexColor2.substring(1, 3), 16);
        g = Integer.valueOf(rgbHexColor2.substring(3, 5), 16);
        b = Integer.valueOf(rgbHexColor2.substring(5, 7), 16);
        this.red2 = (float)r / 255.0f;
        this.green2 = (float)g / 255.0f;
        this.blue2 = (float)b / 255.0f;
    }

    public void setRGBColor(int r, int g, int b, int r2, int g2, int b2) {
        this.red = (float)r / 255.0f;
        this.green = (float)g / 255.0f;
        this.blue = (float)b / 255.0f;
        this.red2 = (float)r2 / 255.0f;
        this.green2 = (float)g2 / 255.0f;
        this.blue2 = (float)b2 / 255.0f;
    }

    public void setColor(Resources resources, int colorResource, int colorResource2) {
        String color = resources.getString(colorResource);
        String color2 = resources.getString(colorResource2);
        this.setRGBColor("#" + color.substring(3), "#" + color2.substring(3));
    }

    public void setColor(int colorResource, int colorResource2) {
        this.red = (float)Color.red((int)colorResource) / 255.0f;
        this.green = (float)Color.green((int)colorResource) / 255.0f;
        this.blue = (float)Color.blue((int)colorResource) / 255.0f;
        this.red2 = (float)Color.red((int)colorResource2) / 255.0f;
        this.green2 = (float)Color.green((int)colorResource2) / 255.0f;
        this.blue2 = (float)Color.blue((int)colorResource2) / 255.0f;
    }
}

