/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.video;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.TimeUtils;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.decoder.BufferDecoder;
import com.pedro.encoder.input.sources.video.VideoSource;
import com.pedro.encoder.utils.yuv.NV21Utils;
import com.pedro.encoder.utils.yuv.YUVUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aJ(\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0014J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016J\b\u0010%\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/pedro/encoder/input/sources/video/BufferVideoSource;", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "format", "Lcom/pedro/encoder/input/sources/video/BufferVideoSource$Format;", "bitrate", "", "<init>", "(Lcom/pedro/encoder/input/sources/video/BufferVideoSource$Format;I)V", "running", "", "videoEncoder", "Lcom/pedro/encoder/video/VideoEncoder;", "decoder", "Lcom/pedro/encoder/input/decoder/BufferDecoder;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "queue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/encoder/Frame;", "surface", "Landroid/view/Surface;", "setBuffer", "", "data", "Ljava/nio/ByteBuffer;", "", "", "create", "width", "height", "fps", "rotation", "start", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "release", "isRunning", "Format", "encoder_release"})
public final class BufferVideoSource
extends VideoSource {
    @NotNull
    private final Format format;
    private final int bitrate;
    private boolean running;
    @NotNull
    private final VideoEncoder videoEncoder;
    @NotNull
    private final BufferDecoder decoder;
    @NotNull
    private CoroutineScope scope;
    @NotNull
    private final BlockingQueue<Frame> queue;
    @Nullable
    private Surface surface;

    public BufferVideoSource(@NotNull Format format, int bitrate) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        this.format = format;
        this.bitrate = bitrate;
        this.videoEncoder = new VideoEncoder(new GetVideoData(this){
            final /* synthetic */ BufferVideoSource this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVideoInfo(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
                Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
            }

            public void getVideoData(ByteBuffer videoBuffer, MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                BufferVideoSource.access$getDecoder$p(this.this$0).decode(ExtensionsKt.toByteArray((ByteBuffer)videoBuffer));
            }

            public void onVideoFormat(MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
            }
        });
        this.decoder = new BufferDecoder(switch (WhenMappings.$EnumSwitchMapping$0[this.format.ordinal()]) {
            case 1 -> VideoCodec.H265;
            case 2 -> VideoCodec.AV1;
            default -> VideoCodec.H264;
        });
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.queue = new ArrayBlockingQueue(80);
    }

    public final void setBuffer(@NotNull ByteBuffer data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.setBuffer(ExtensionsKt.toByteArray((ByteBuffer)data));
    }

    public final void setBuffer(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!this.running) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.format.ordinal()]) {
            case 3: 
            case 4: {
                throw new IllegalStateException("Use setBuffer IntArray instead");
            }
            case 5: 
            case 6: {
                Boolean bl = this.queue.offer(new Frame(data, 0, data.length, TimeUtils.getCurrentTimeMicro()));
                break;
            }
            default: {
                Boolean bl = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, data, null){
                    int label;
                    final /* synthetic */ BufferVideoSource this$0;
                    final /* synthetic */ byte[] $data;
                    {
                        this.this$0 = $receiver;
                        this.$data = $data;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                BufferVideoSource.access$getDecoder$p(this.this$0).decode(this.$data);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public final void setBuffer(@NotNull int[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!this.running) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.format.ordinal()]) {
            case 3: 
            case 4: {
                byte[] yuv = YUVUtil.ARGBtoYUV420SemiPlanar(data, this.getWidth(), this.getHeight());
                Intrinsics.checkNotNull((Object)yuv);
                this.queue.offer(new Frame(yuv, 0, yuv.length, TimeUtils.getCurrentTimeMicro()));
                break;
            }
            default: {
                throw new IllegalStateException("Method only supported with format RGB and ARGB");
            }
        }
    }

    @Override
    protected boolean create(int width, int height, int fps, int rotation) {
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, this.bitrate, rotation, 2, FormatVideoEncoder.YUV420Dynamical);
        this.decoder.prepare(width, height, fps, rotation);
        NV21Utils.preAllocateBuffers(width * height * 3 / 2);
        return result;
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.queue.clear();
        this.running = true;
        this.videoEncoder.prepareVideoEncoder(this.getWidth(), this.getHeight(), this.getFps(), this.bitrate, this.getRotation(), 2, FormatVideoEncoder.YUV420Dynamical);
        this.decoder.prepare(this.getWidth(), this.getHeight(), this.getFps(), this.getRotation());
        this.videoEncoder.start();
        this.surface = new Surface(surfaceTexture);
        this.decoder.start(this.surface);
        switch (WhenMappings.$EnumSwitchMapping$0[this.format.ordinal()]) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ BufferVideoSource this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                while (BufferVideoSource.access$getRunning$p(this.this$0)) {
                                    Frame frame = (Frame)BufferVideoSource.access$getQueue$p(this.this$0).take();
                                    BufferVideoSource.access$getVideoEncoder$p(this.this$0).inputYUVData(frame);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    @Override
    public void stop() {
        block0: {
            this.running = false;
            CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
            this.videoEncoder.stop();
            this.decoder.stop();
            this.queue.clear();
            Surface surface = this.surface;
            if (surface == null) break block0;
            surface.release();
        }
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public static final /* synthetic */ BufferDecoder access$getDecoder$p(BufferVideoSource $this) {
        return $this.decoder;
    }

    public static final /* synthetic */ boolean access$getRunning$p(BufferVideoSource $this) {
        return $this.running;
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(BufferVideoSource $this) {
        return $this.queue;
    }

    public static final /* synthetic */ VideoEncoder access$getVideoEncoder$p(BufferVideoSource $this) {
        return $this.videoEncoder;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/pedro/encoder/input/sources/video/BufferVideoSource$Format;", "", "<init>", "(Ljava/lang/String;I)V", "H264", "H265", "AV1", "RGB", "ARGB", "NV21", "NV12", "encoder_release"})
    public static final class Format
    extends Enum<Format> {
        public static final /* enum */ Format H264 = new Format();
        public static final /* enum */ Format H265 = new Format();
        public static final /* enum */ Format AV1 = new Format();
        public static final /* enum */ Format RGB = new Format();
        public static final /* enum */ Format ARGB = new Format();
        public static final /* enum */ Format NV21 = new Format();
        public static final /* enum */ Format NV12 = new Format();
        private static final /* synthetic */ Format[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String value) {
            return Enum.valueOf(Format.class, value);
        }

        @NotNull
        public static EnumEntries<Format> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = formatArray = new Format[]{Format.H264, Format.H265, Format.AV1, Format.RGB, Format.ARGB, Format.NV21, Format.NV12};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Format.values().length];
            try {
                nArray[Format.H265.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Format.AV1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Format.RGB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Format.ARGB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Format.NV21.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Format.NV12.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

