/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.utils.gl.GlUtil;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(api=18)
public class SurfaceManager {
    private static final String TAG = "SurfaceManager";
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLContext eglContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface eglSurface = EGL14.EGL_NO_SURFACE;
    private EGLDisplay eglDisplay = EGL14.EGL_NO_DISPLAY;
    private final AtomicBoolean isReady = new AtomicBoolean(false);

    public boolean isReady() {
        return this.isReady.get();
    }

    public boolean makeCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
            Log.e((String)TAG, (String)"eglMakeCurrent failed");
            return false;
        }
        return true;
    }

    public void swapBuffer() {
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface)) {
            Log.e((String)TAG, (String)"eglSwapBuffers failed");
        }
    }

    public void setPresentationTime(long nsecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)nsecs);
        GlUtil.checkEglError("eglPresentationTimeANDROID");
    }

    public void eglSetup(int width, int height, Surface surface, EGLContext eglSharedContext) {
        if (this.isReady()) {
            Log.e((String)TAG, (String)"already ready, ignored");
            return;
        }
        this.eglDisplay = EGL14.eglGetDisplay((int)0);
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            throw new RuntimeException("unable to initialize EGL14");
        }
        int[] attribList = eglSharedContext == null && surface == null ? new int[]{12324, 8, 12323, 8, 12322, 8, 12339, 1, 12352, 4, 12344} : (eglSharedContext == null ? new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12344} : (surface == null ? new int[]{12324, 8, 12323, 8, 12322, 8, 12339, 1, 12352, 4, 12610, 1, 12344} : new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12610, 1, 12344}));
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        EGL14.eglChooseConfig((EGLDisplay)this.eglDisplay, (int[])attribList, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0);
        GlUtil.checkEglError("eglCreateContext RGB888+recordable ES2");
        int[] attrib_list = new int[]{12440, 2, 12344};
        this.eglContext = EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (EGLContext)(eglSharedContext == null ? EGL14.EGL_NO_CONTEXT : eglSharedContext), (int[])attrib_list, (int)0);
        GlUtil.checkEglError("eglCreateContext");
        if (surface == null) {
            int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
            this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (int[])surfaceAttribs, (int)0);
        } else {
            int[] surfaceAttribs = new int[]{12344};
            this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (Object)surface, (int[])surfaceAttribs, (int)0);
        }
        GlUtil.checkEglError("eglCreateWindowSurface");
        this.isReady.set(true);
        Log.i((String)TAG, (String)"GL initialized");
    }

    public void eglSetup(Surface surface, SurfaceManager manager) {
        this.eglSetup(2, 2, surface, manager.eglContext);
    }

    public void eglSetup(int width, int height, SurfaceManager manager) {
        this.eglSetup(width, height, null, manager.eglContext);
    }

    public void eglSetup(Surface surface, EGLContext eglContext) {
        this.eglSetup(2, 2, surface, eglContext);
    }

    public void eglSetup(Surface surface) {
        this.eglSetup(2, 2, surface, null);
    }

    public void eglSetup() {
        this.eglSetup(2, 2, null, null);
    }

    public void release() {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
            Log.i((String)TAG, (String)"GL released");
            this.eglDisplay = EGL14.EGL_NO_DISPLAY;
            this.eglContext = EGL14.EGL_NO_CONTEXT;
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        } else {
            Log.e((String)TAG, (String)"GL already released");
        }
        this.isReady.set(false);
    }

    public EGLContext getEglContext() {
        return this.eglContext;
    }

    public EGLSurface getEglSurface() {
        return this.eglSurface;
    }

    public EGLDisplay getEglDisplay() {
        return this.eglDisplay;
    }
}

