/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.sources.video.VideoSource;
import com.pedro.encoder.input.video.Camera1ApiManager;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.facedetector.FaceDetectorCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\tJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\rJ\u0006\u0010 \u001a\u00020\rJ\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020\u000bJ\u0006\u0010$\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010&\u001a\u00020\u000bJ\u0016\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u001a\u0010,\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010-\u001a\u00020\rH\u0007J\u000e\u0010,\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\rJ\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0/J\u0006\u00100\u001a\u00020\rJ\u000e\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\u0012J\u0006\u00105\u001a\u00020\u000bJ\u000e\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\rJ\u0006\u00108\u001a\u00020\u000bJ\u0006\u00109\u001a\u00020\u0012J\u0006\u0010:\u001a\u00020\u000bJ\u0010\u0010;\u001a\u00020\u00122\b\u0010<\u001a\u0004\u0018\u00010=J\u000e\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020@J/\u0010A\u001a&\u0012\f\u0012\n C*\u0004\u0018\u00010@0@ C*\u0012\u0012\f\u0012\n C*\u0004\u0018\u00010@0@\u0018\u00010\u001c0B\u00a2\u0006\u0002\u0010DJ\u0013\u0010E\u001a\n C*\u0004\u0018\u00010@0@\u00a2\u0006\u0002\u0010FR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/pedro/encoder/input/sources/video/Camera1Source;", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "camera", "Lcom/pedro/encoder/input/video/Camera1ApiManager;", "facing", "Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "create", "", "width", "", "height", "fps", "rotation", "start", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "release", "isRunning", "checkResolutionSupported", "switchCamera", "getCameraFacing", "getCameraResolutions", "", "Landroid/util/Size;", "setExposure", "level", "getExposure", "enableLantern", "disableLantern", "isLanternEnabled", "enableAutoFocus", "disableAutoFocus", "isAutoFocusEnabled", "tapToFocus", "view", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "setZoom", "delta", "getZoomRange", "Landroid/util/Range;", "getZoom", "enableFaceDetection", "callback", "Lcom/pedro/encoder/input/video/facedetector/FaceDetectorCallback;", "disableFaceDetection", "isFaceDetectionEnabled", "openCameraId", "id", "enableVideoStabilization", "disableVideoStabilization", "isVideoStabilizationEnabled", "setCameraCallback", "callbacks", "Lcom/pedro/encoder/input/video/CameraCallbacks;", "enableAutoWhiteBalance", "mode", "", "getAutoWhiteBalanceModesAvailable", "", "kotlin.jvm.PlatformType", "()Ljava/util/List;", "getWhiteBalance", "()Ljava/lang/String;", "encoder_release"})
@RequiresApi(value=21)
@SourceDebugExtension(value={"SMAP\nCamera1Source.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Camera1Source.kt\ncom/pedro/encoder/input/sources/video/Camera1Source\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1557#2:196\n1628#2,3:197\n1557#2:201\n1628#2,3:202\n1#3:200\n*S KotlinDebug\n*F\n+ 1 Camera1Source.kt\ncom/pedro/encoder/input/sources/video/Camera1Source\n*L\n80#1:196\n80#1:197,3\n105#1:201\n105#1:202,3\n*E\n"})
public final class Camera1Source
extends VideoSource {
    @NotNull
    private final Camera1ApiManager camera;
    @NotNull
    private CameraHelper.Facing facing;

    public Camera1Source(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.camera = new Camera1ApiManager(null, context);
        this.facing = CameraHelper.Facing.BACK;
    }

    @Override
    protected boolean create(int width, int height, int fps, int rotation) {
        boolean result = this.checkResolutionSupported(width, height);
        if (!result) {
            throw new IllegalArgumentException("Unsupported resolution: " + width + "x" + height);
        }
        return true;
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.setSurfaceTexture(surfaceTexture);
        if (!this.isRunning()) {
            surfaceTexture.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.camera.setSurfaceTexture(surfaceTexture);
            this.camera.start(this.facing, this.getWidth(), this.getHeight(), this.getFps());
            this.camera.setPreviewOrientation(90);
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.camera.stop();
        }
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRunning() {
        return this.camera.isRunning();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkResolutionSupported(int width, int height) {
        Object v0;
        block3: {
            void $this$mapTo$iv$iv;
            if (width % 2 != 0 || height % 2 != 0) {
                throw new IllegalArgumentException("width and height values must be divisible by 2");
            }
            boolean shouldRotate = width < height;
            int w = shouldRotate ? height : width;
            int h = shouldRotate ? width : height;
            Size size = new Size(w, h);
            List<Camera.Size> resolutions = this.facing == CameraHelper.Facing.BACK ? this.camera.getPreviewSizeBack() : this.camera.getPreviewSizeFront();
            Intrinsics.checkNotNull(resolutions);
            Iterable $this$map$iv = resolutions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Camera.Size size2 = (Camera.Size)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Size(it.width, it.height));
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                Size it = (Size)e;
                boolean bl = false;
                if (!(it.getWidth() == size.getWidth() && it.getHeight() == size.getHeight())) continue;
                v0 = e;
                break block3;
            }
            v0 = null;
        }
        return v0 != null;
    }

    public final void switchCamera() {
        block1: {
            CameraHelper.Facing facing = this.facing = this.facing == CameraHelper.Facing.BACK ? CameraHelper.Facing.FRONT : CameraHelper.Facing.BACK;
            if (!this.isRunning()) break block1;
            this.stop();
            SurfaceTexture surfaceTexture = this.getSurfaceTexture();
            if (surfaceTexture != null) {
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                this.start(it);
            }
        }
    }

    @NotNull
    public final CameraHelper.Facing getCameraFacing() {
        return this.facing;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Size> getCameraResolutions(@NotNull CameraHelper.Facing facing) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)facing), (String)"facing");
        List<Camera.Size> resolutions = facing == CameraHelper.Facing.FRONT ? this.camera.getPreviewSizeFront() : this.camera.getPreviewSizeBack();
        Intrinsics.checkNotNull(resolutions);
        Iterable $this$map$iv = resolutions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Camera.Size size = (Camera.Size)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Size(it.width, it.height));
        }
        return (List)destination$iv$iv;
    }

    public final void setExposure(int level) {
        if (this.isRunning()) {
            this.camera.setExposure(level);
        }
    }

    public final int getExposure() {
        return this.isRunning() ? this.camera.getExposure() : 0;
    }

    public final void enableLantern() {
        if (this.isRunning()) {
            this.camera.enableLantern();
        }
    }

    public final void disableLantern() {
        if (this.isRunning()) {
            this.camera.disableLantern();
        }
    }

    public final boolean isLanternEnabled() {
        return this.isRunning() ? this.camera.isLanternEnabled() : false;
    }

    public final boolean enableAutoFocus() {
        if (this.isRunning()) {
            return this.camera.enableAutoFocus();
        }
        return false;
    }

    public final boolean disableAutoFocus() {
        if (this.isRunning()) {
            return this.camera.disableAutoFocus();
        }
        return false;
    }

    public final boolean isAutoFocusEnabled() {
        return this.isRunning() ? this.camera.isAutoFocusEnabled() : false;
    }

    public final boolean tapToFocus(@NotNull View view, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.camera.tapToFocus(view, event);
    }

    @JvmOverloads
    public final void setZoom(@NotNull MotionEvent event, int delta) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isRunning()) {
            this.camera.setZoom(event, delta);
        }
    }

    public static /* synthetic */ void setZoom$default(Camera1Source camera1Source, MotionEvent motionEvent, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        camera1Source.setZoom(motionEvent, n);
    }

    public final void setZoom(int level) {
        if (this.isRunning()) {
            this.camera.setZoom(level);
        }
    }

    @NotNull
    public final Range<Integer> getZoomRange() {
        return new Range((Comparable)Integer.valueOf(this.camera.getMinZoom()), (Comparable)Integer.valueOf(this.camera.getMaxZoom()));
    }

    public final int getZoom() {
        return this.camera.getZoom();
    }

    public final boolean enableFaceDetection(@NotNull FaceDetectorCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        return this.isRunning() ? this.camera.enableFaceDetection(callback2) : false;
    }

    public final void disableFaceDetection() {
        if (this.isRunning()) {
            this.camera.disableFaceDetection();
        }
    }

    public final boolean isFaceDetectionEnabled() {
        return this.camera.isFaceDetectionEnabled();
    }

    public final void openCameraId(int id) {
        this.camera.switchCamera(id);
    }

    public final boolean enableVideoStabilization() {
        return this.isRunning() ? this.camera.enableVideoStabilization() : false;
    }

    public final void disableVideoStabilization() {
        if (this.isRunning()) {
            this.camera.disableVideoStabilization();
        }
    }

    public final boolean isVideoStabilizationEnabled() {
        return this.camera.isVideoStabilizationEnabled();
    }

    public final void setCameraCallback(@Nullable CameraCallbacks callbacks) {
        this.camera.setCameraCallbacks(callbacks);
    }

    public final boolean enableAutoWhiteBalance(@NotNull String mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return this.camera.enableAutoWhiteBalance(mode);
    }

    public final List<String> getAutoWhiteBalanceModesAvailable() {
        return this.camera.getAutoWhiteBalanceModesAvailable();
    }

    public final String getWhiteBalance() {
        return this.camera.getWhiteBalance();
    }

    @JvmOverloads
    public final void setZoom(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Camera1Source.setZoom$default(this, event, 0, 2, null);
    }
}

