/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.audio;

import android.media.AudioPlaybackCaptureConfiguration;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.sources.MediaProjectionHandler;
import com.pedro.encoder.input.sources.audio.AudioSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0017J\u0006\u0010 \u001a\u00020\u0017J\u0006\u0010!\u001a\u00020\u0010J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lcom/pedro/encoder/input/sources/audio/InternalAudioSource;", "Lcom/pedro/encoder/input/sources/audio/AudioSource;", "Lcom/pedro/encoder/input/audio/GetMicrophoneData;", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaProjectionCallback", "Landroid/media/projection/MediaProjection$Callback;", "<init>", "(Landroid/media/projection/MediaProjection;Landroid/media/projection/MediaProjection$Callback;)V", "TAG", "", "microphone", "Lcom/pedro/encoder/input/audio/MicrophoneManager;", "handlerThread", "Landroid/os/HandlerThread;", "create", "", "sampleRate", "", "isStereo", "echoCanceler", "noiseSuppressor", "start", "", "getMicrophoneData", "stop", "isRunning", "release", "inputPCMData", "frame", "Lcom/pedro/encoder/Frame;", "mute", "unMute", "isMuted", "setAudioEffect", "effect", "Lcom/pedro/encoder/input/audio/CustomAudioEffect;", "value", "", "internalVolume", "getInternalVolume", "()F", "setInternalVolume", "(F)V", "encoder_release"})
@RequiresApi(value=29)
public final class InternalAudioSource
extends AudioSource
implements GetMicrophoneData {
    @NotNull
    private final String TAG;
    @NotNull
    private final MicrophoneManager microphone;
    @NotNull
    private HandlerThread handlerThread;
    @NotNull
    private final MediaProjection.Callback mediaProjectionCallback;

    public InternalAudioSource(@NotNull MediaProjection mediaProjection, @Nullable MediaProjection.Callback mediaProjectionCallback2) {
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this.TAG = "InternalAudioSource";
        this.microphone = new MicrophoneManager(this);
        this.handlerThread = new HandlerThread(this.TAG);
        MediaProjection.Callback callback2 = mediaProjectionCallback2;
        if (callback2 == null) {
            callback2 = new MediaProjection.Callback(){};
        }
        this.mediaProjectionCallback = callback2;
        MediaProjectionHandler.INSTANCE.setMediaProjection(mediaProjection);
    }

    public /* synthetic */ InternalAudioSource(MediaProjection mediaProjection, MediaProjection.Callback callback2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            callback2 = null;
        }
        this(mediaProjection, callback2);
    }

    @Override
    protected boolean create(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        boolean result = this.microphone.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (!result) {
            throw new IllegalArgumentException("Some parameters specified are not valid");
        }
        return true;
    }

    @Override
    public void start(@NotNull GetMicrophoneData getMicrophoneData) {
        Intrinsics.checkNotNullParameter((Object)getMicrophoneData, (String)"getMicrophoneData");
        this.setGetMicrophoneData(getMicrophoneData);
        if (!this.isRunning()) {
            block6: {
                if (Build.VERSION.SDK_INT >= 29) {
                    this.handlerThread = new HandlerThread(this.TAG);
                    this.handlerThread.start();
                    MediaProjection mediaProjection = MediaProjectionHandler.INSTANCE.getMediaProjection();
                    if (mediaProjection != null) {
                        mediaProjection.registerCallback(this.mediaProjectionCallback, new Handler(this.handlerThread.getLooper()));
                    }
                    MediaProjection mediaProjection2 = MediaProjectionHandler.INSTANCE.getMediaProjection();
                    Intrinsics.checkNotNull((Object)mediaProjection2);
                    AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration = new AudioPlaybackCaptureConfiguration.Builder(mediaProjection2).addMatchingUsage(1).addMatchingUsage(14).addMatchingUsage(0).build();
                    Intrinsics.checkNotNullExpressionValue((Object)audioPlaybackCaptureConfiguration, (String)"build(...)");
                    AudioPlaybackCaptureConfiguration config = audioPlaybackCaptureConfiguration;
                    try {
                        boolean result = this.microphone.createInternalMicrophone(config, this.getSampleRate(), this.isStereo(), this.getEchoCanceler(), this.getNoiseSuppressor());
                        if (!result) {
                            throw new IllegalArgumentException("Failed to create internal audio source");
                        }
                        break block6;
                    }
                    catch (UnsupportedOperationException e) {
                        throw new IllegalArgumentException("invalid MediaProjection used");
                    }
                }
                throw new IllegalStateException("Using internal audio in a invalid Android version. Android 10+ is necessary");
            }
            this.microphone.start();
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.setGetMicrophoneData(null);
            this.microphone.stop();
            this.handlerThread.quitSafely();
        }
    }

    @Override
    public boolean isRunning() {
        return this.microphone.isRunning();
    }

    @Override
    public void release() {
        block0: {
            MediaProjection mediaProjection = MediaProjectionHandler.INSTANCE.getMediaProjection();
            if (mediaProjection == null) break block0;
            mediaProjection.unregisterCallback(this.mediaProjectionCallback);
        }
    }

    @Override
    public void inputPCMData(@NotNull Frame frame) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            GetMicrophoneData getMicrophoneData = this.getGetMicrophoneData();
            if (getMicrophoneData == null) break block0;
            getMicrophoneData.inputPCMData(frame);
        }
    }

    public final void mute() {
        this.microphone.mute();
    }

    public final void unMute() {
        this.microphone.unMute();
    }

    public final boolean isMuted() {
        return this.microphone.isMuted();
    }

    public final void setAudioEffect(@NotNull CustomAudioEffect effect) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        this.microphone.setCustomAudioEffect(effect);
    }

    public final float getInternalVolume() {
        return this.microphone.getInternalVolume();
    }

    public final void setInternalVolume(float value) {
        this.microphone.setInternalVolume(value);
    }
}

