/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.render.CameraRender;
import com.pedro.encoder.input.gl.render.RenderHandler;
import com.pedro.encoder.input.gl.render.ScreenRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0019J6\u0010\u001c\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019J6\u0010\"\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019J>\u0010$\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010%\u001a\u00020\u0015J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0011H\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0011H\u0002J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0011H\u0002J\b\u0010*\u001a\u00020\u0015H\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\tH\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0011H\u0002J\b\u0010,\u001a\u00020\u0015H\u0002J\u001e\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0011J\u0006\u00100\u001a\u00020\tJ\u0016\u00101\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u0006\u00102\u001a\u00020\u0015J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\tJ\u000e\u00108\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\tJ\u000e\u00109\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\tJ\u0016\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/pedro/encoder/input/gl/render/MainRender;", "", "<init>", "()V", "cameraRender", "Lcom/pedro/encoder/input/gl/render/CameraRender;", "screenRender", "Lcom/pedro/encoder/input/gl/render/ScreenRender;", "width", "", "height", "previewWidth", "previewHeight", "context", "Landroid/content/Context;", "filterRenders", "", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "initGl", "", "encoderWidth", "encoderHeight", "isReady", "", "drawOffScreen", "isPreview", "drawScreen", "mode", "Lcom/pedro/encoder/utils/gl/AspectRatioMode;", "rotation", "flipStreamVertical", "flipStreamHorizontal", "drawScreenEncoder", "isPortrait", "drawScreenPreview", "release", "setFilter", "position", "baseFilterRender", "addFilter", "clearFilters", "removeFilter", "reOrderFilters", "setFilterAction", "filterAction", "Lcom/pedro/encoder/input/gl/FilterAction;", "filtersCount", "setPreviewSize", "updateFrame", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "getSurface", "Landroid/view/Surface;", "setCameraRotation", "setCameraRotationStream", "setCameraRotationPreview", "setCameraFlip", "isFlipHorizontal", "isFlipVertical", "encoder_release"})
@RequiresApi(api=18)
public final class MainRender {
    @NotNull
    private final CameraRender cameraRender = new CameraRender();
    @NotNull
    private final ScreenRender screenRender = new ScreenRender();
    private int width;
    private int height;
    private int previewWidth;
    private int previewHeight;
    @Nullable
    private Context context;
    @NotNull
    private List<BaseFilterRender> filterRenders = new ArrayList();
    @NotNull
    private final AtomicBoolean running = new AtomicBoolean(false);

    public final void initGl(@NotNull Context context, int encoderWidth, int encoderHeight, int previewWidth, int previewHeight) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.width = encoderWidth;
        this.height = encoderHeight;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.cameraRender.initGl(this.width, this.height, context, previewWidth, previewHeight);
        this.screenRender.setStreamSize(encoderWidth, encoderHeight);
        this.screenRender.setTexId(this.cameraRender.getTexId());
        this.screenRender.initGl(context);
        this.running.set(true);
    }

    public final boolean isReady() {
        return this.running.get();
    }

    public final void drawOffScreen(boolean isPreview) {
        this.cameraRender.setMode(isPreview);
        this.cameraRender.draw();
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.draw();
        }
    }

    public final void drawScreen(int width, int height, @NotNull AspectRatioMode mode, int rotation, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.screenRender.draw(width, height, mode, rotation, flipStreamVertical, flipStreamHorizontal);
    }

    public final void drawScreenEncoder(int width, int height, boolean isPortrait, int rotation, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        this.screenRender.drawEncoder(width, height, isPortrait, rotation, flipStreamVertical, flipStreamHorizontal);
    }

    public final void drawScreenPreview(int width, int height, boolean isPortrait, @NotNull AspectRatioMode mode, int rotation, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.screenRender.drawPreview(width, height, isPortrait, mode, rotation, flipStreamVertical, flipStreamHorizontal);
    }

    public final void release() {
        this.running.set(false);
        this.cameraRender.release();
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.release();
        }
        this.filterRenders.clear();
        this.screenRender.release();
    }

    private final void setFilter(int position, BaseFilterRender baseFilterRender) {
        int id = this.filterRenders.get(position).getPreviousTexId();
        RenderHandler renderHandler = this.filterRenders.get(position).getRenderHandler();
        this.filterRenders.get(position).release();
        this.filterRenders.set(position, baseFilterRender);
        this.filterRenders.get(position).setPreviousTexId(id);
        this.filterRenders.get(position).initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        this.filterRenders.get(position).setRenderHandler(renderHandler);
    }

    private final void addFilter(BaseFilterRender baseFilterRender) {
        this.filterRenders.add(baseFilterRender);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private final void addFilter(int position, BaseFilterRender baseFilterRender) {
        this.filterRenders.add(position, baseFilterRender);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private final void clearFilters() {
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.release();
        }
        this.filterRenders.clear();
        this.reOrderFilters();
    }

    private final void removeFilter(int position) {
        this.filterRenders.remove(position).release();
        this.reOrderFilters();
    }

    private final void removeFilter(BaseFilterRender baseFilterRender) {
        baseFilterRender.release();
        this.filterRenders.remove(baseFilterRender);
        this.reOrderFilters();
    }

    private final void reOrderFilters() {
        int n = ((Collection)this.filterRenders).size();
        for (int i = 0; i < n; ++i) {
            int texId = i == 0 ? this.cameraRender.getTexId() : this.filterRenders.get(i - 1).getTexId();
            this.filterRenders.get(i).setPreviousTexId(texId);
        }
        int texId = this.filterRenders.isEmpty() ? this.cameraRender.getTexId() : this.filterRenders.get(this.filterRenders.size() - 1).getTexId();
        this.screenRender.setTexId(texId);
    }

    public final void setFilterAction(@NotNull FilterAction filterAction, int position, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterAction), (String)"filterAction");
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        switch (WhenMappings.$EnumSwitchMapping$0[filterAction.ordinal()]) {
            case 1: {
                if (this.filterRenders.size() > 0) {
                    this.setFilter(position, baseFilterRender);
                    break;
                }
                this.addFilter(baseFilterRender);
                break;
            }
            case 2: {
                this.setFilter(position, baseFilterRender);
                break;
            }
            case 3: {
                this.addFilter(baseFilterRender);
                break;
            }
            case 4: {
                this.addFilter(position, baseFilterRender);
                break;
            }
            case 5: {
                this.clearFilters();
                break;
            }
            case 6: {
                this.removeFilter(baseFilterRender);
                break;
            }
            case 7: {
                this.removeFilter(position);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final int filtersCount() {
        return this.filterRenders.size();
    }

    public final void setPreviewSize(int previewWidth, int previewHeight) {
        int n = ((Collection)this.filterRenders).size();
        for (int i = 0; i < n; ++i) {
            this.filterRenders.get(i).setPreviewSize(previewWidth, previewHeight);
        }
    }

    public final void updateFrame() {
        this.cameraRender.updateTexImage();
    }

    @NotNull
    public final SurfaceTexture getSurfaceTexture() {
        SurfaceTexture surfaceTexture = this.cameraRender.getSurfaceTexture();
        Intrinsics.checkNotNullExpressionValue((Object)surfaceTexture, (String)"getSurfaceTexture(...)");
        return surfaceTexture;
    }

    @NotNull
    public final Surface getSurface() {
        Surface surface = this.cameraRender.getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
        return surface;
    }

    public final void setCameraRotation(int rotation) {
        this.cameraRender.setRotation(rotation);
    }

    public final void setCameraRotationStream(int rotation) {
        this.cameraRender.setRotationStream(rotation);
    }

    public final void setCameraRotationPreview(int rotation) {
        this.cameraRender.setRotationPreview(rotation);
    }

    public final void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.cameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterAction.values().length];
            try {
                nArray[FilterAction.SET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterAction.SET_INDEX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterAction.ADD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterAction.ADD_INDEX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterAction.CLEAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterAction.REMOVE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterAction.REMOVE_INDEX.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

