/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.view.Surface;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.Extractor;
import com.pedro.encoder.input.decoder.VideoDecoder;
import com.pedro.encoder.input.sources.OrientationForced;
import com.pedro.encoder.input.sources.video.VideoFileSource;
import com.pedro.encoder.input.sources.video.VideoSource;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000*\u0001\u0013\u0018\u00002\u00020\u0001BF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ(\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0014J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u000e\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0006\u0010*\u001a\u00020(J\u000e\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u0007J\u0016\u0010-\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0005J\u000e\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u000201R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/pedro/encoder/input/sources/video/VideoFileSource;", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "context", "Landroid/content/Context;", "path", "Landroid/net/Uri;", "loopMode", "", "onFinish", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isLoop", "", "<init>", "(Landroid/content/Context;Landroid/net/Uri;ZLkotlin/jvm/functions/Function1;)V", "videoDecoderInterface", "Lkotlin/Function0;", "decoderInterface", "com/pedro/encoder/input/sources/video/VideoFileSource$decoderInterface$1", "Lcom/pedro/encoder/input/sources/video/VideoFileSource$decoderInterface$1;", "running", "videoDecoder", "Lcom/pedro/encoder/input/decoder/VideoDecoder;", "create", "width", "", "height", "fps", "rotation", "start", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "release", "isRunning", "getOrientationConfig", "Lcom/pedro/encoder/input/sources/OrientationForced;", "moveTo", "time", "", "getDuration", "getTime", "setLoopMode", "enabled", "replaceFile", "uri", "setExtractor", "extractor", "Lcom/pedro/encoder/input/decoder/Extractor;", "encoder_release"})
public final class VideoFileSource
extends VideoSource {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri path;
    @NotNull
    private final Function0<Unit> videoDecoderInterface;
    @NotNull
    private final decoderInterface.1 decoderInterface;
    private boolean running;
    @NotNull
    private VideoDecoder videoDecoder;

    public VideoFileSource(@NotNull Context context, @NotNull Uri path, boolean loopMode, @NotNull Function1<? super Boolean, Unit> onFinish) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        this.context = context;
        this.path = path;
        this.videoDecoderInterface = () -> VideoFileSource.videoDecoderInterface$lambda$1(onFinish);
        this.decoderInterface = new DecoderInterface(onFinish){
            final /* synthetic */ Function1<Boolean, Unit> $onFinish;
            {
                this.$onFinish = $onFinish;
            }

            public void onLoop() {
                this.$onFinish.invoke((Object)true);
            }
        };
        this.videoDecoder = new VideoDecoder(() -> VideoFileSource.videoDecoder$lambda$2(this.videoDecoderInterface), this.decoderInterface);
        this.setLoopMode(loopMode);
    }

    public /* synthetic */ VideoFileSource(Context context, Uri uri, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function1 = VideoFileSource::_init_$lambda$0;
        }
        this(context, uri, bl, (Function1<? super Boolean, Unit>)function1);
    }

    @Override
    protected boolean create(int width, int height, int fps, int rotation) {
        boolean result = this.videoDecoder.initExtractor(this.context, this.path);
        if (!result) {
            throw new IllegalArgumentException("Video file track not found");
        }
        return true;
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.setSurfaceTexture(surfaceTexture);
        this.videoDecoder.prepareVideo(new Surface(surfaceTexture));
        this.videoDecoder.start();
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
        this.videoDecoder.stop();
    }

    @Override
    public void release() {
        if (this.running) {
            this.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    @NotNull
    public OrientationForced getOrientationConfig() {
        return OrientationForced.LANDSCAPE;
    }

    public final void moveTo(double time) {
        this.videoDecoder.moveTo(time);
    }

    public final double getDuration() {
        return this.videoDecoder.getDuration();
    }

    public final double getTime() {
        return this.videoDecoder.getTime();
    }

    public final void setLoopMode(boolean enabled) {
        this.videoDecoder.setLoopMode(enabled);
    }

    public final void replaceFile(@NotNull Context context, @NotNull Uri uri) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        boolean wasRunning = this.videoDecoder.isRunning();
        VideoDecoder videoDecoder = new VideoDecoder(() -> VideoFileSource.replaceFile$lambda$3(this.videoDecoderInterface), this.decoderInterface);
        videoDecoder.setExtractor(this.videoDecoder.getExtractor());
        if (!videoDecoder.initExtractor(context, uri)) {
            throw new IOException("Extraction failed");
        }
        this.videoDecoder.stop();
        this.videoDecoder = videoDecoder;
        if (wasRunning) {
            videoDecoder.prepareVideo(new Surface(this.getSurfaceTexture()));
            videoDecoder.start();
        }
    }

    public final void setExtractor(@NotNull Extractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        this.videoDecoder.setExtractor(extractor);
    }

    private static final Unit _init_$lambda$0(boolean it) {
        return Unit.INSTANCE;
    }

    private static final Unit videoDecoderInterface$lambda$1(Function1 $onFinish) {
        $onFinish.invoke((Object)false);
        return Unit.INSTANCE;
    }

    private static final void videoDecoder$lambda$2(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void replaceFile$lambda$3(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

