/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import com.pedro.encoder.utils.ViewPort;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import kotlin.Pair;

public class SizeCalculator {
    public static ViewPort calculateViewPort(AspectRatioMode mode, int previewWidth, int previewHeight, int streamWidth, int streamHeight) {
        if (mode == AspectRatioMode.NONE) {
            return new ViewPort(0, 0, previewWidth, previewHeight);
        }
        float streamAspectRatio = (float)streamWidth / (float)streamHeight;
        float previewAspectRatio = (float)previewWidth / (float)previewHeight;
        int xo = 0;
        int yo = 0;
        int xf = previewWidth;
        int yf = previewHeight;
        if (mode == AspectRatioMode.Adjust) {
            if (streamAspectRatio > previewAspectRatio) {
                yf = streamHeight * previewWidth / streamWidth;
                yo = (yf - previewHeight) / -2;
            } else {
                xf = streamWidth * previewHeight / streamHeight;
                xo = (xf - previewWidth) / -2;
            }
        } else if (streamAspectRatio > previewAspectRatio) {
            xf = streamWidth * previewHeight / streamHeight;
            xo = (xf - previewWidth) / -2;
        } else {
            yf = streamHeight * previewWidth / streamWidth;
            yo = (yf - previewHeight) / -2;
        }
        return new ViewPort(xo, yo, xf, yf);
    }

    public static ViewPort calculateViewPortEncoder(int streamWidth, int streamHeight, boolean isPortrait) {
        float factor = (float)streamWidth / (float)streamHeight;
        if (factor >= 1.0f) {
            if (isPortrait) {
                int width = (int)((float)streamHeight / factor);
                int oX = (streamWidth - width) / 2;
                return new ViewPort(oX, 0, width, streamHeight);
            }
            return new ViewPort(0, 0, streamWidth, streamHeight);
        }
        if (isPortrait) {
            return new ViewPort(0, 0, streamWidth, streamHeight);
        }
        int height = (int)((float)streamWidth * factor);
        int oY = (streamHeight - height) / 2;
        return new ViewPort(0, oY, streamWidth, height);
    }

    public static Pair<Float, Float> calculateFlip(boolean flipStreamHorizontal, boolean flipStreamVertical) {
        return new Pair((Object)Float.valueOf(flipStreamHorizontal ? -1.0f : 1.0f), (Object)Float.valueOf(flipStreamVertical ? -1.0f : 1.0f));
    }
}

