/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.audio;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/pedro/encoder/audio/G711Codec;", "", "()V", "configure", "", "sampleRate", "", "channels", "decode", "", "src", "offset", "len", "encode", "buffer", "size", "linearToALawSample", "", "mySample", "", "Companion", "encoder_release"})
public final class G711Codec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int cClip = 32635;
    @NotNull
    private static final short[] aLawDecompressTable;
    @NotNull
    private static final byte[] aLawCompressTable;

    public final void configure(int sampleRate, int channels) {
        if (!(sampleRate == 8000 && channels == 1)) {
            boolean bl = false;
            String string = "G711 codec only support 8000 sampleRate and mono channel";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final byte[] encode(@NotNull byte[] buffer, int offset, int size) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int j = offset;
        int count = size / 2;
        byte[] out = new byte[count];
        for (int i = 0; i < count; ++i) {
            short sample = (short)(buffer[j++] & 0xFF | buffer[j++] << 8);
            out[i] = this.linearToALawSample(sample);
        }
        return out;
    }

    @NotNull
    public final byte[] decode(@NotNull byte[] src, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int j = 0;
        byte[] out = new byte[src.length * 2];
        for (int i = 0; i < len; ++i) {
            short s = aLawDecompressTable[src[i + offset] & 0xFF];
            out[j++] = (byte)s;
            out[j++] = (byte)(s >> 8);
        }
        return out;
    }

    private final byte linearToALawSample(short mySample) {
        int n;
        int sample = mySample;
        int sign = (short)(~sample) >> 8 & 0x80;
        if (sign != 128) {
            sample = (short)(-sample);
        }
        if (sample > 32635) {
            sample = 32635;
        }
        if (sample >= 256) {
            byte exponent = aLawCompressTable[sample >> 8 & 0x7F];
            int mantissa = sample >> exponent + 3 & 0xF;
            n = exponent << 4 | mantissa;
        } else {
            n = sample >> 4;
        }
        int s = n;
        return (byte)(s ^= sign ^ 0x55);
    }

    static {
        Object[] objectArray = new short[]{-5504, -5248, -6016, -5760, -4480, -4224, -4992, -4736, -7552, -7296, -8064, -7808, -6528, -6272, -7040, -6784, -2752, -2624, -3008, -2880, -2240, -2112, -2496, -2368, -3776, -3648, -4032, -3904, -3264, -3136, -3520, -3392, -22016, -20992, -24064, -23040, -17920, -16896, -19968, -18944, -30208, -29184, -32256, -31232, -26112, -25088, -28160, -27136, -11008, -10496, -12032, -11520, -8960, -8448, -9984, -9472, -15104, -14592, -16128, -15616, -13056, -12544, -14080, -13568, -344, -328, -376, -360, -280, -264, -312, -296, -472, -456, -504, -488, -408, -392, -440, -424, -88, -72, -120, -104, -24, -8, -56, -40, -216, -200, -248, -232, -152, -136, -184, -168, -1376, -1312, -1504, -1440, -1120, -1056, -1248, -1184, -1888, -1824, -2016, -1952, -1632, -1568, -1760, -1696, -688, -656, -752, -720, -560, -528, -624, -592, -944, -912, -1008, -976, -816, -784, -880, -848, 5504, 5248, 6016, 5760, 4480, 4224, 4992, 4736, 7552, 7296, 8064, 7808, 6528, 6272, 7040, 6784, 2752, 2624, 3008, 2880, 2240, 2112, 2496, 2368, 3776, 3648, 4032, 3904, 3264, 3136, 3520, 3392, 22016, 20992, 24064, 23040, 17920, 16896, 19968, 18944, 30208, 29184, 32256, 31232, 26112, 25088, 28160, 27136, 11008, 10496, 12032, 11520, 8960, 8448, 9984, 9472, 15104, 14592, 16128, 15616, 13056, 12544, 14080, 13568, 344, 328, 376, 360, 280, 264, 312, 296, 472, 456, 504, 488, 408, 392, 440, 424, 88, 72, 120, 104, 24, 8, 56, 40, 216, 200, 248, 232, 152, 136, 184, 168, 1376, 1312, 1504, 1440, 1120, 1056, 1248, 1184, 1888, 1824, 2016, 1952, 1632, 1568, 1760, 1696, 688, 656, 752, 720, 560, 528, 624, 592, 944, 912, 1008, 976, 816, 784, 880, 848};
        aLawDecompressTable = objectArray;
        objectArray = new byte[128];
        objectArray[0] = 1;
        objectArray[1] = 1;
        objectArray[2] = 2;
        objectArray[3] = 2;
        objectArray[4] = 3;
        objectArray[5] = 3;
        objectArray[6] = 3;
        objectArray[7] = 3;
        objectArray[8] = 4;
        objectArray[9] = 4;
        objectArray[10] = 4;
        objectArray[11] = 4;
        objectArray[12] = 4;
        objectArray[13] = 4;
        objectArray[14] = 4;
        objectArray[15] = 4;
        objectArray[16] = 5;
        objectArray[17] = 5;
        objectArray[18] = 5;
        objectArray[19] = 5;
        objectArray[20] = 5;
        objectArray[21] = 5;
        objectArray[22] = 5;
        objectArray[23] = 5;
        objectArray[24] = 5;
        objectArray[25] = 5;
        objectArray[26] = 5;
        objectArray[27] = 5;
        objectArray[28] = 5;
        objectArray[29] = 5;
        objectArray[30] = 5;
        objectArray[31] = 5;
        objectArray[32] = 6;
        objectArray[33] = 6;
        objectArray[34] = 6;
        objectArray[35] = 6;
        objectArray[36] = 6;
        objectArray[37] = 6;
        objectArray[38] = 6;
        objectArray[39] = 6;
        objectArray[40] = 6;
        objectArray[41] = 6;
        objectArray[42] = 6;
        objectArray[43] = 6;
        objectArray[44] = 6;
        objectArray[45] = 6;
        objectArray[46] = 6;
        objectArray[47] = 6;
        objectArray[48] = 6;
        objectArray[49] = 6;
        objectArray[50] = 6;
        objectArray[51] = 6;
        objectArray[52] = 6;
        objectArray[53] = 6;
        objectArray[54] = 6;
        objectArray[55] = 6;
        objectArray[56] = 6;
        objectArray[57] = 6;
        objectArray[58] = 6;
        objectArray[59] = 6;
        objectArray[60] = 6;
        objectArray[61] = 6;
        objectArray[62] = 6;
        objectArray[63] = 6;
        objectArray[64] = 7;
        objectArray[65] = 7;
        objectArray[66] = 7;
        objectArray[67] = 7;
        objectArray[68] = 7;
        objectArray[69] = 7;
        objectArray[70] = 7;
        objectArray[71] = 7;
        objectArray[72] = 7;
        objectArray[73] = 7;
        objectArray[74] = 7;
        objectArray[75] = 7;
        objectArray[76] = 7;
        objectArray[77] = 7;
        objectArray[78] = 7;
        objectArray[79] = 7;
        objectArray[80] = 7;
        objectArray[81] = 7;
        objectArray[82] = 7;
        objectArray[83] = 7;
        objectArray[84] = 7;
        objectArray[85] = 7;
        objectArray[86] = 7;
        objectArray[87] = 7;
        objectArray[88] = 7;
        objectArray[89] = 7;
        objectArray[90] = 7;
        objectArray[91] = 7;
        objectArray[92] = 7;
        objectArray[93] = 7;
        objectArray[94] = 7;
        objectArray[95] = 7;
        objectArray[96] = 7;
        objectArray[97] = 7;
        objectArray[98] = 7;
        objectArray[99] = 7;
        objectArray[100] = 7;
        objectArray[101] = 7;
        objectArray[102] = 7;
        objectArray[103] = 7;
        objectArray[104] = 7;
        objectArray[105] = 7;
        objectArray[106] = 7;
        objectArray[107] = 7;
        objectArray[108] = 7;
        objectArray[109] = 7;
        objectArray[110] = 7;
        objectArray[111] = 7;
        objectArray[112] = 7;
        objectArray[113] = 7;
        objectArray[114] = 7;
        objectArray[115] = 7;
        objectArray[116] = 7;
        objectArray[117] = 7;
        objectArray[118] = 7;
        objectArray[119] = 7;
        objectArray[120] = 7;
        objectArray[121] = 7;
        objectArray[122] = 7;
        objectArray[123] = 7;
        objectArray[124] = 7;
        objectArray[125] = 7;
        objectArray[126] = 7;
        objectArray[127] = 7;
        aLawCompressTable = (byte[])objectArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/pedro/encoder/audio/G711Codec$Companion;", "", "()V", "aLawCompressTable", "", "aLawDecompressTable", "", "cClip", "", "encoder_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

