/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaExtractor;
import android.os.Build;
import android.view.Surface;
import com.pedro.encoder.input.decoder.BaseDecoder;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import java.nio.ByteBuffer;

public class VideoDecoder
extends BaseDecoder {
    private final VideoDecoderInterface videoDecoderInterface;
    private int width;
    private int height;
    private int fps;

    public VideoDecoder(VideoDecoderInterface videoDecoderInterface, DecoderInterface decoderInterface) {
        super(decoderInterface);
        this.TAG = "VideoDecoder";
        this.videoDecoderInterface = videoDecoderInterface;
    }

    @Override
    protected boolean extract(MediaExtractor videoExtractor) {
        for (int i = 0; i < videoExtractor.getTrackCount() && !this.mime.startsWith("video/"); ++i) {
            this.mediaFormat = videoExtractor.getTrackFormat(i);
            this.mime = this.mediaFormat.getString("mime");
            if (this.mime.startsWith("video/")) {
                videoExtractor.selectTrack(i);
                continue;
            }
            this.mediaFormat = null;
        }
        if (this.mediaFormat != null) {
            this.width = this.mediaFormat.getInteger("width");
            this.height = this.mediaFormat.getInteger("height");
            this.duration = this.mediaFormat.getLong("durationUs");
            this.fps = this.mediaFormat.getInteger("frame-rate");
            return true;
        }
        this.mime = "";
        return false;
    }

    public boolean prepareVideo(Surface surface) {
        return this.prepare(surface);
    }

    @Override
    protected boolean decodeOutput(ByteBuffer outputBuffer) {
        return true;
    }

    @Override
    protected void finished() {
        this.videoDecoderInterface.onVideoDecoderFinished();
    }

    public void changeOutputSurface(Surface surface) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.codec.setOutputSurface(surface);
        } else {
            this.resetCodec(surface);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFps() {
        return this.fps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseRender() {
        Object object = this.sync;
        synchronized (object) {
            this.pause.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRender() {
        Object object = this.sync;
        synchronized (object) {
            this.pause.set(false);
        }
    }
}

