/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;

@RequiresApi(api=21)
public class Camera2ApiManager
extends CameraDevice.StateCallback {
    private final String TAG = "Camera2ApiManager";
    private CameraDevice cameraDevice;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private Surface surfaceEncoder;
    private CameraManager cameraManager;
    private Handler cameraHandler;
    private CameraCaptureSession cameraCaptureSession;
    private boolean prepared = false;
    private int cameraId = -1;
    private boolean isFrontCamera = false;
    private CaptureRequest.Builder builderInputSurface;
    private float fingerSpacing = 0.0f;
    private float zoomLevel = 1.0f;
    private boolean lanternEnable = false;
    private boolean autoFocusEnabled = true;
    private boolean running = false;
    private final Semaphore semaphore = new Semaphore(0);
    private CameraCallbacks cameraCallbacks;
    private FaceDetectorCallback faceDetectorCallback;
    private boolean faceDetectionEnabled = false;
    private int faceDetectionMode;
    private final CameraCaptureSession.CaptureCallback cb = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            Face[] faces = (Face[])result.get(CaptureResult.STATISTICS_FACES);
            if (Camera2ApiManager.this.faceDetectorCallback != null) {
                Camera2ApiManager.this.faceDetectorCallback.onGetFaces(faces);
            }
        }
    };

    public Camera2ApiManager(Context context) {
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    public void prepareCamera(SurfaceView surfaceView, Surface surface) {
        this.surfaceView = surfaceView;
        this.surfaceEncoder = surface;
        this.prepared = true;
    }

    public void prepareCamera(TextureView textureView, Surface surface) {
        this.textureView = textureView;
        this.surfaceEncoder = surface;
        this.prepared = true;
    }

    public void prepareCamera(Surface surface) {
        this.surfaceEncoder = surface;
        this.prepared = true;
    }

    public void prepareCamera(SurfaceTexture surfaceTexture, int width, int height) {
        surfaceTexture.setDefaultBufferSize(width, height);
        this.surfaceEncoder = new Surface(surfaceTexture);
        this.prepared = true;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    private void startPreview(CameraDevice cameraDevice) {
        try {
            final ArrayList<Surface> listSurfaces = new ArrayList<Surface>();
            Surface preview = this.addPreviewSurface();
            if (preview != null) {
                listSurfaces.add(preview);
            }
            if (this.surfaceEncoder != preview && this.surfaceEncoder != null) {
                listSurfaces.add(this.surfaceEncoder);
            }
            cameraDevice.createCaptureSession(listSurfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Camera2ApiManager.this.cameraCaptureSession = cameraCaptureSession;
                    try {
                        CaptureRequest captureRequest = Camera2ApiManager.this.drawSurface(listSurfaces);
                        if (captureRequest != null) {
                            cameraCaptureSession.setRepeatingRequest(captureRequest, Camera2ApiManager.this.faceDetectionEnabled ? Camera2ApiManager.this.cb : null, Camera2ApiManager.this.cameraHandler);
                            Log.i((String)"Camera2ApiManager", (String)"Camera configured");
                        } else {
                            Log.e((String)"Camera2ApiManager", (String)"Error, captureRequest is null");
                        }
                    }
                    catch (CameraAccessException | NullPointerException e) {
                        Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        Camera2ApiManager.this.reOpenCamera(Camera2ApiManager.this.cameraId != -1 ? Camera2ApiManager.this.cameraId : 0);
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    cameraCaptureSession.close();
                    Log.e((String)"Camera2ApiManager", (String)"Configuration failed");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
        catch (IllegalStateException e) {
            this.reOpenCamera(this.cameraId != -1 ? this.cameraId : 0);
        }
    }

    private Surface addPreviewSurface() {
        Surface surface = null;
        if (this.surfaceView != null) {
            surface = this.surfaceView.getHolder().getSurface();
        } else if (this.textureView != null) {
            SurfaceTexture texture = this.textureView.getSurfaceTexture();
            surface = new Surface(texture);
        }
        return surface;
    }

    private CaptureRequest drawSurface(List<Surface> surfaces) {
        try {
            this.builderInputSurface = this.cameraDevice.createCaptureRequest(1);
            for (Surface surface : surfaces) {
                if (surface == null) continue;
                this.builderInputSurface.addTarget(surface);
            }
            return this.builderInputSurface.build();
        }
        catch (CameraAccessException | IllegalStateException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return null;
        }
    }

    public int getLevelSupported() {
        try {
            CameraCharacteristics characteristics = this.getCameraCharacteristics();
            if (characteristics == null) {
                return -1;
            }
            Integer level = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (level == null) {
                return -1;
            }
            return level;
        }
        catch (IllegalStateException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return -1;
        }
    }

    public void openCamera() {
        this.openCameraBack();
    }

    public void openCameraBack() {
        this.openCameraFacing(CameraHelper.Facing.BACK);
    }

    public void openCameraFront() {
        this.openCameraFacing(CameraHelper.Facing.FRONT);
    }

    public void openLastCamera() {
        if (this.cameraId == -1) {
            this.openCameraBack();
        } else {
            this.openCameraId(this.cameraId);
        }
    }

    public Size[] getCameraResolutionsBack() {
        return this.getCameraResolutions(CameraHelper.Facing.BACK);
    }

    public Size[] getCameraResolutionsFront() {
        return this.getCameraResolutions(CameraHelper.Facing.FRONT);
    }

    public Size[] getCameraResolutions(CameraHelper.Facing facing) {
        try {
            CameraCharacteristics characteristics = this.getCharacteristicsForFacing(this.cameraManager, facing);
            if (characteristics == null) {
                return new Size[0];
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamConfigurationMap == null) {
                return new Size[0];
            }
            Size[] outputSizes = streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
            return outputSizes != null ? outputSizes : new Size[]{};
        }
        catch (CameraAccessException | NullPointerException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return new Size[0];
        }
    }

    @Nullable
    public CameraCharacteristics getCameraCharacteristics() {
        try {
            return this.cameraId != -1 ? this.cameraManager.getCameraCharacteristics(String.valueOf(this.cameraId)) : null;
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return null;
        }
    }

    public void openCameraFacing(CameraHelper.Facing selectedCameraFacing) {
        try {
            String cameraId = this.getCameraIdForFacing(this.cameraManager, selectedCameraFacing);
            if (cameraId != null) {
                this.openCameraId(Integer.valueOf(cameraId));
            } else {
                Log.e((String)"Camera2ApiManager", (String)"Camera not supported");
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    public boolean isLanternSupported() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return false;
        }
        Boolean available = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (available == null) {
            return false;
        }
        return available;
    }

    public boolean isLanternEnabled() {
        return this.lanternEnable;
    }

    public void enableLantern() throws Exception {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        Boolean available = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (available == null) {
            return;
        }
        if (available.booleanValue()) {
            if (this.builderInputSurface != null) {
                try {
                    this.builderInputSurface.set(CaptureRequest.FLASH_MODE, (Object)2);
                    this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                    this.lanternEnable = true;
                }
                catch (Exception e) {
                    Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                }
            }
        } else {
            Log.e((String)"Camera2ApiManager", (String)"Lantern unsupported");
            throw new Exception("Lantern unsupported");
        }
    }

    public void disableLantern() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        Boolean available = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (available == null) {
            return;
        }
        if (available.booleanValue() && this.builderInputSurface != null) {
            try {
                this.builderInputSurface.set(CaptureRequest.FLASH_MODE, (Object)0);
                this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                this.lanternEnable = false;
            }
            catch (Exception e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
    }

    public void enableAutoFocus() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        int[] supportedFocusModes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (supportedFocusModes != null) {
            ArrayList<Integer> focusModesList = new ArrayList<Integer>();
            for (int i : supportedFocusModes) {
                focusModesList.add(i);
            }
            if (this.builderInputSurface != null) {
                try {
                    if (focusModesList.contains(4)) {
                        this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                        this.autoFocusEnabled = true;
                    } else if (focusModesList.contains(1)) {
                        this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                        this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                        this.autoFocusEnabled = true;
                    }
                }
                catch (Exception e) {
                    Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                }
            }
        }
    }

    public void disableAutoFocus() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        int[] supportedFocusModes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (supportedFocusModes != null && this.builderInputSurface != null) {
            for (int mode : supportedFocusModes) {
                try {
                    if (mode == 0) {
                        this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
                        this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                        this.autoFocusEnabled = false;
                        return;
                    }
                }
                catch (Exception e) {
                    Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                }
            }
        }
    }

    public boolean isAutoFocusEnabled() {
        return this.autoFocusEnabled;
    }

    public void enableFaceDetection(FaceDetectorCallback faceDetectorCallback) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        int[] fd = (int[])characteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        if (fd == null) {
            return;
        }
        Integer maxFD = (Integer)characteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (maxFD == null) {
            return;
        }
        if (fd.length > 0) {
            ArrayList<Integer> fdList = new ArrayList<Integer>();
            for (int FaceD : fd) {
                fdList.add(FaceD);
            }
            if (maxFD > 0) {
                this.faceDetectorCallback = faceDetectorCallback;
                this.faceDetectionEnabled = true;
                this.faceDetectionMode = (Integer)Collections.max(fdList);
                this.setFaceDetect(this.builderInputSurface, this.faceDetectionMode);
                this.prepareFaceDetectionCallback();
            } else {
                Log.e((String)"Camera2ApiManager", (String)"No face detection");
            }
        } else {
            Log.e((String)"Camera2ApiManager", (String)"No face detection");
        }
    }

    public void disableFaceDetection() {
        if (this.faceDetectionEnabled) {
            this.faceDetectorCallback = null;
            this.faceDetectionEnabled = false;
            this.faceDetectionMode = 0;
            this.prepareFaceDetectionCallback();
        }
    }

    public boolean isFaceDetectionEnabled() {
        return this.faceDetectorCallback != null;
    }

    private void setFaceDetect(CaptureRequest.Builder requestBuilder, int faceDetectMode) {
        if (this.faceDetectionEnabled) {
            requestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)faceDetectMode);
        }
    }

    public void setCameraCallbacks(CameraCallbacks cameraCallbacks) {
        this.cameraCallbacks = cameraCallbacks;
    }

    private void prepareFaceDetectionCallback() {
        try {
            this.cameraCaptureSession.stopRepeating();
            this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void openCameraId(Integer cameraId) {
        this.cameraId = cameraId;
        if (this.prepared) {
            HandlerThread cameraHandlerThread = new HandlerThread("Camera2ApiManager Id = " + cameraId);
            cameraHandlerThread.start();
            this.cameraHandler = new Handler(cameraHandlerThread.getLooper());
            try {
                this.cameraManager.openCamera(cameraId.toString(), (CameraDevice.StateCallback)this, this.cameraHandler);
                this.semaphore.acquireUninterruptibly();
                CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(Integer.toString(cameraId));
                this.running = true;
                Integer facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                if (facing == null) {
                    return;
                }
                boolean bl = this.isFrontCamera = 0 == facing;
                if (this.cameraCallbacks != null) {
                    this.cameraCallbacks.onCameraChanged(this.isFrontCamera);
                }
            }
            catch (CameraAccessException | SecurityException e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        } else {
            Log.e((String)"Camera2ApiManager", (String)"Camera2ApiManager need be prepared, Camera2ApiManager not enabled");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void switchCamera() {
        try {
            String cameraId = this.cameraDevice == null || this.isFrontCamera ? this.getCameraIdForFacing(this.cameraManager, CameraHelper.Facing.BACK) : this.getCameraIdForFacing(this.cameraManager, CameraHelper.Facing.FRONT);
            if (cameraId == null) {
                cameraId = "0";
            }
            this.reOpenCamera(Integer.parseInt(cameraId));
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    private void reOpenCamera(int cameraId) {
        if (this.cameraDevice != null) {
            this.closeCamera(false);
            if (this.textureView != null) {
                this.prepareCamera(this.textureView, this.surfaceEncoder);
            } else if (this.surfaceView != null) {
                this.prepareCamera(this.surfaceView, this.surfaceEncoder);
            } else {
                this.prepareCamera(this.surfaceEncoder);
            }
            this.openCameraId(cameraId);
        }
    }

    public float getMaxZoom() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return 1.0f;
        }
        Float maxZoom = (Float)characteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom == null) {
            return 1.0f;
        }
        return maxZoom.floatValue();
    }

    public Float getZoom() {
        return Float.valueOf(this.zoomLevel);
    }

    public void setZoom(Float level) {
        try {
            float maxZoom = this.getMaxZoom();
            CameraCharacteristics characteristics = this.getCameraCharacteristics();
            if (characteristics == null) {
                return;
            }
            Rect m = (Rect)characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            if (m == null) {
                return;
            }
            if (level.floatValue() <= maxZoom && level.floatValue() >= 1.0f) {
                this.zoomLevel = level.floatValue();
                int minW = (int)((float)m.width() / (maxZoom * 10.0f));
                int minH = (int)((float)m.height() / (maxZoom * 10.0f));
                int difW = m.width() - minW;
                int difH = m.height() - minH;
                int cropW = (int)((float)(difW / 10) * level.floatValue());
                int cropH = (int)((float)(difH / 10) * level.floatValue());
                cropW -= cropW & 3;
                cropH -= cropH & 3;
                Rect zoom = new Rect(cropW, cropH, m.width() - cropW, m.height() - cropH);
                this.builderInputSurface.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoom);
                this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    public void setZoom(MotionEvent event) {
        if (event.getPointerCount() > 1) {
            float currentFingerSpacing = CameraHelper.getFingerSpacing(event);
            if (this.fingerSpacing != 0.0f) {
                if (currentFingerSpacing > this.fingerSpacing && this.getMaxZoom() > this.zoomLevel) {
                    this.zoomLevel += 0.1f;
                } else if (currentFingerSpacing < this.fingerSpacing && this.zoomLevel > 1.0f) {
                    this.zoomLevel -= 0.1f;
                }
                this.setZoom(Float.valueOf(this.zoomLevel));
            }
            this.fingerSpacing = currentFingerSpacing;
        }
    }

    public boolean isFrontCamera() {
        return this.isFrontCamera;
    }

    private void resetCameraValues() {
        this.lanternEnable = false;
        this.zoomLevel = 1.0f;
    }

    public void stopRepeatingEncoder() {
        if (this.cameraCaptureSession != null) {
            try {
                this.cameraCaptureSession.stopRepeating();
                this.surfaceEncoder = null;
                Surface preview = this.addPreviewSurface();
                if (preview != null) {
                    CaptureRequest captureRequest = this.drawSurface(Collections.singletonList(preview));
                    if (captureRequest != null) {
                        this.cameraCaptureSession.setRepeatingRequest(captureRequest, null, this.cameraHandler);
                    }
                } else {
                    Log.e((String)"Camera2ApiManager", (String)"preview surface is null");
                }
            }
            catch (CameraAccessException e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
    }

    public void closeCamera() {
        this.closeCamera(true);
    }

    public void closeCamera(boolean resetSurface) {
        this.resetCameraValues();
        if (this.cameraCaptureSession != null) {
            this.cameraCaptureSession.close();
            this.cameraCaptureSession = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        if (this.cameraHandler != null) {
            this.cameraHandler.getLooper().quitSafely();
            this.cameraHandler = null;
        }
        if (resetSurface) {
            this.surfaceEncoder = null;
            this.builderInputSurface = null;
        }
        this.prepared = false;
        this.running = false;
    }

    public void onOpened(@NonNull CameraDevice cameraDevice) {
        this.cameraDevice = cameraDevice;
        this.startPreview(cameraDevice);
        this.semaphore.release();
        Log.i((String)"Camera2ApiManager", (String)"Camera opened");
    }

    public void onDisconnected(@NonNull CameraDevice cameraDevice) {
        cameraDevice.close();
        this.semaphore.release();
        Log.i((String)"Camera2ApiManager", (String)"Camera disconnected");
    }

    public void onError(@NonNull CameraDevice cameraDevice, int i) {
        cameraDevice.close();
        this.semaphore.release();
        Log.e((String)"Camera2ApiManager", (String)"Open failed");
    }

    @Nullable
    private String getCameraIdForFacing(CameraManager cameraManager, CameraHelper.Facing facing) throws CameraAccessException {
        int selectedFacing = Camera2ApiManager.getFacing(facing);
        for (String cameraId : cameraManager.getCameraIdList()) {
            Integer cameraFacing = (Integer)cameraManager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.LENS_FACING);
            if (cameraFacing == null || cameraFacing != selectedFacing) continue;
            return cameraId;
        }
        return null;
    }

    @Nullable
    private CameraCharacteristics getCharacteristicsForFacing(CameraManager cameraManager, CameraHelper.Facing facing) throws CameraAccessException {
        String cameraId = this.getCameraIdForFacing(cameraManager, facing);
        return cameraId != null ? cameraManager.getCameraCharacteristics(cameraId) : null;
    }

    private static int getFacing(CameraHelper.Facing facing) {
        return facing == CameraHelper.Facing.BACK ? 1 : 0;
    }

    public static interface FaceDetectorCallback {
        public void onGetFaces(Face[] var1);
    }
}

