/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.content.Context;
import android.view.MotionEvent;
import android.view.WindowManager;

public class CameraHelper {
    private static final float[] verticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};

    public static float[] getVerticesData() {
        return verticesData;
    }

    public static int getCameraOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            int orientation = windowManager.getDefaultDisplay().getRotation();
            switch (orientation) {
                case 0: {
                    return 90;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 270;
                }
                case 3: {
                    return 180;
                }
            }
            return 0;
        }
        return 0;
    }

    public static float getFingerSpacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    public static enum Facing {
        BACK,
        FRONT;

    }
}

