/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.encoder.input.video.Camera1Facing;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.EffectManager;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.YUVUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class Camera1ApiManager
implements Camera.PreviewCallback,
Camera.FaceDetectionListener {
    private String TAG = "Camera1ApiManager";
    private Camera camera = null;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private SurfaceTexture surfaceTexture;
    private GetCameraData getCameraData;
    private boolean running = false;
    private volatile boolean prepared = false;
    private boolean lanternEnable = false;
    private int cameraSelect;
    private boolean isFrontCamera = false;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int orientation = 0;
    private int imageFormat = 17;
    private HandlerThread handlerThread;
    private Handler thread;
    private byte[] yuvBuffer;
    private List<Camera.Size> previewSizeBack;
    private List<Camera.Size> previewSizeFront;

    public Camera1ApiManager(SurfaceView surfaceView, GetCameraData getCameraData) {
        this.surfaceView = surfaceView;
        this.getCameraData = getCameraData;
        this.init(surfaceView.getContext());
    }

    public Camera1ApiManager(TextureView textureView, GetCameraData getCameraData) {
        this.textureView = textureView;
        this.getCameraData = getCameraData;
        this.init(textureView.getContext());
    }

    public Camera1ApiManager(SurfaceTexture surfaceTexture, Context context) {
        this.surfaceTexture = surfaceTexture;
        this.init(context);
    }

    private void init(Context context) {
        if (context.getResources().getConfiguration().orientation == 1) {
            this.orientation = 90;
        }
        this.cameraSelect = this.selectCameraFront();
        this.previewSizeFront = this.getPreviewSize();
        this.cameraSelect = this.selectCameraBack();
        this.previewSizeBack = this.getPreviewSize();
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.surfaceTexture = surfaceTexture;
    }

    public void prepareCamera(int width, int height, int fps, int imageFormat) {
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.imageFormat = imageFormat;
        this.prepared = true;
    }

    public void prepareCamera() {
        this.prepareCamera(640, 480, this.fps, this.imageFormat);
    }

    public void start(@Camera1Facing int cameraFacing, int width, int height) {
        this.width = width;
        this.height = height;
        this.cameraSelect = cameraFacing == 0 ? this.selectCameraBack() : this.selectCameraFront();
        this.start();
    }

    public void start(@Camera1Facing int cameraFacing) {
        this.start(cameraFacing, this.width, this.height);
    }

    public void start() {
        if (!this.checkCanOpen()) {
            throw new CameraOpenException("This camera resolution cant be opened");
        }
        this.handlerThread = new HandlerThread("cameraThread");
        this.handlerThread.start();
        this.thread = new Handler(this.handlerThread.getLooper());
        this.thread.post(new Runnable(){

            @Override
            public void run() {
                Camera1ApiManager.access$002(Camera1ApiManager.this, new byte[Camera1ApiManager.this.width * Camera1ApiManager.this.height * 3 / 2]);
                YUVUtil.preAllocateRotateBuffers(Camera1ApiManager.this.yuvBuffer.length);
                YUVUtil.preAllocateNv21Buffers(Camera1ApiManager.this.yuvBuffer.length);
                if (Camera1ApiManager.this.imageFormat == 842094169) {
                    YUVUtil.preAllocateYv12Buffers(Camera1ApiManager.this.yuvBuffer.length);
                }
                if (Camera1ApiManager.this.camera == null && Camera1ApiManager.this.prepared) {
                    try {
                        Camera1ApiManager.this.camera = Camera.open((int)Camera1ApiManager.this.cameraSelect);
                        Camera.CameraInfo info = new Camera.CameraInfo();
                        Camera.getCameraInfo((int)Camera1ApiManager.this.cameraSelect, (Camera.CameraInfo)info);
                        Camera1ApiManager.this.isFrontCamera = info.facing == 1;
                        Camera.Parameters parameters = Camera1ApiManager.this.camera.getParameters();
                        parameters.setPreviewSize(Camera1ApiManager.this.width, Camera1ApiManager.this.height);
                        parameters.setPreviewFormat(Camera1ApiManager.this.imageFormat);
                        int[] range = Camera1ApiManager.this.adaptFpsRange(Camera1ApiManager.this.fps, parameters.getSupportedPreviewFpsRange());
                        parameters.setPreviewFpsRange(range[0], range[1]);
                        List supportedFocusModes = parameters.getSupportedFocusModes();
                        if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
                            if (supportedFocusModes.contains("continuous-picture")) {
                                parameters.setFocusMode("continuous-picture");
                            } else if (supportedFocusModes.contains("auto")) {
                                parameters.setFocusMode("auto");
                            } else {
                                parameters.setFocusMode((String)supportedFocusModes.get(0));
                            }
                        }
                        Camera1ApiManager.this.camera.setParameters(parameters);
                        Camera1ApiManager.this.camera.setDisplayOrientation(Camera1ApiManager.this.orientation);
                        if (Camera1ApiManager.this.surfaceView != null) {
                            Camera1ApiManager.this.camera.setPreviewDisplay(Camera1ApiManager.this.surfaceView.getHolder());
                            Camera1ApiManager.this.camera.addCallbackBuffer(Camera1ApiManager.this.yuvBuffer);
                            Camera1ApiManager.this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)Camera1ApiManager.this);
                        } else if (Camera1ApiManager.this.textureView != null) {
                            Camera1ApiManager.this.camera.setPreviewTexture(Camera1ApiManager.this.textureView.getSurfaceTexture());
                            Camera1ApiManager.this.camera.addCallbackBuffer(Camera1ApiManager.this.yuvBuffer);
                            Camera1ApiManager.this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)Camera1ApiManager.this);
                        } else {
                            Camera1ApiManager.this.camera.setPreviewTexture(Camera1ApiManager.this.surfaceTexture);
                        }
                        Camera1ApiManager.this.camera.startPreview();
                        Camera1ApiManager.this.running = true;
                        Log.i((String)Camera1ApiManager.this.TAG, (String)(Camera1ApiManager.this.width + "X" + Camera1ApiManager.this.height));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    Log.e((String)Camera1ApiManager.this.TAG, (String)"Camera1ApiManager need be prepared, Camera1ApiManager not enabled");
                }
            }
        });
    }

    public void setPreviewOrientation(int orientation) {
        this.orientation = orientation;
        if (this.camera != null && this.running) {
            this.camera.stopPreview();
            this.camera.setDisplayOrientation(orientation);
            this.camera.startPreview();
        }
    }

    private int selectCameraBack() {
        int number = Camera.getNumberOfCameras();
        int i = 0;
        while (i < number) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 0) {
                return i;
            }
            this.cameraSelect = i++;
        }
        return this.cameraSelect;
    }

    private int selectCameraFront() {
        int number = Camera.getNumberOfCameras();
        int i = 0;
        while (i < number) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                return i;
            }
            this.cameraSelect = i++;
        }
        return this.cameraSelect;
    }

    public void stop() {
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.setPreviewCallbackWithBuffer(null);
            this.camera.release();
            this.camera = null;
            if (this.surfaceView != null || this.textureView != null) {
                // empty if block
            }
        }
        if (this.handlerThread != null) {
            this.handlerThread.quit();
            this.handlerThread = null;
        }
        if (this.thread != null) {
            this.thread.removeCallbacksAndMessages(null);
            this.thread = null;
        }
        this.running = false;
        this.prepared = false;
    }

    private void clearSurface(Object texture) {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        egl.eglInitialize(display, null);
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344, 0, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        egl.eglChooseConfig(display, attribList, configs, configs.length, numConfigs);
        EGLConfig config = configs[0];
        EGLContext context = egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, new int[]{12440, 2, 12344});
        EGLSurface eglSurface = egl.eglCreateWindowSurface(display, config, texture, new int[]{12344});
        egl.eglMakeCurrent(display, eglSurface, eglSurface, context);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        egl.eglSwapBuffers(display, eglSurface);
        egl.eglDestroySurface(display, eglSurface);
        egl.eglMakeCurrent(display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        egl.eglDestroyContext(display, context);
        egl.eglTerminate(display);
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    private int[] adaptFpsRange(int expectedFps, List<int[]> fpsRanges) {
        int[] closestRange = fpsRanges.get(0);
        int measure = Math.abs(closestRange[0] - (expectedFps *= 1000)) + Math.abs(closestRange[1] - expectedFps);
        for (int[] range : fpsRanges) {
            int curMeasure;
            if (range[0] > expectedFps || range[1] < expectedFps || (curMeasure = Math.abs(range[0] - expectedFps) + Math.abs(range[1] - expectedFps)) >= measure) continue;
            closestRange = range;
            measure = curMeasure;
        }
        return closestRange;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.imageFormat == 842094169) {
            data = YUVUtil.YV12toNV21(data, this.width, this.height);
        }
        if (this.isFrontCamera && (this.orientation == 90 || this.orientation == 270)) {
            data = YUVUtil.rotateNV21(data, this.width, this.height, 180);
        }
        this.getCameraData.inputYUVData(data);
        camera.addCallbackBuffer(this.yuvBuffer);
    }

    public List<Integer> getCameraPreviewImageFormatSupported() {
        List formats;
        if (this.camera != null) {
            formats = this.camera.getParameters().getSupportedPreviewFormats();
            for (Integer i : formats) {
                Log.i((String)this.TAG, (String)("camera format supported: " + i));
            }
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            formats = this.camera.getParameters().getSupportedPreviewFormats();
            this.camera.release();
            this.camera = null;
        }
        return formats;
    }

    private List<Camera.Size> getPreviewSize() {
        List previewSizes;
        Camera.Size maxSize;
        if (this.camera != null) {
            maxSize = this.getMaxEncoderSizeSupported();
            previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            maxSize = this.getMaxEncoderSizeSupported();
            previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
            this.camera.release();
            this.camera = null;
        }
        Iterator iterator = previewSizes.iterator();
        while (iterator.hasNext()) {
            Camera.Size size = (Camera.Size)iterator.next();
            if (size.width <= maxSize.width && size.height <= maxSize.height) continue;
            Log.i((String)this.TAG, (String)(size.width + "X" + size.height + ", not supported for encoder"));
            iterator.remove();
        }
        return previewSizes;
    }

    public List<Camera.Size> getPreviewSizeBack() {
        return this.previewSizeBack;
    }

    public List<Camera.Size> getPreviewSizeFront() {
        return this.previewSizeFront;
    }

    private Camera.Size getMaxEncoderSizeSupported() {
        if (CamcorderProfile.hasProfile((int)8)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 3840, 2160);
        }
        if (CamcorderProfile.hasProfile((int)6)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 1920, 1080);
        }
        if (CamcorderProfile.hasProfile((int)5)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 1280, 720);
        }
        Camera camera = this.camera;
        camera.getClass();
        return new Camera.Size(camera, 640, 480);
    }

    public void setEffect(EffectManager effect) {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setColorEffect(effect.getEffect());
            try {
                this.camera.setParameters(parameters);
            }
            catch (RuntimeException e) {
                Log.e((String)this.TAG, (String)"Unsupported effect: ", (Throwable)e);
            }
        }
    }

    public void switchCamera() throws CameraOpenException {
        if (this.camera != null) {
            int oldCamera = this.cameraSelect;
            int number = Camera.getNumberOfCameras();
            for (int i = 0; i < number; ++i) {
                if (this.cameraSelect == i) continue;
                this.cameraSelect = i;
                if (!this.checkCanOpen()) {
                    this.cameraSelect = oldCamera;
                    throw new CameraOpenException("This camera resolution cant be opened");
                }
                this.stop();
                this.prepared = true;
                this.start();
                return;
            }
        }
    }

    private boolean checkCanOpen() {
        List<Camera.Size> previews = this.cameraSelect == this.selectCameraBack() ? this.previewSizeBack : this.previewSizeFront;
        for (Camera.Size size : previews) {
            if (size.width != this.width || size.height != this.height) continue;
            return true;
        }
        return false;
    }

    public boolean isLanternEnable() {
        return this.lanternEnable;
    }

    public void enableLantern() {
        Camera.Parameters parameters;
        List supportedFlashModes;
        if (this.camera != null && (supportedFlashModes = (parameters = this.camera.getParameters()).getSupportedFlashModes()) != null && !supportedFlashModes.isEmpty()) {
            if (supportedFlashModes.contains("torch")) {
                parameters.setFlashMode("torch");
                this.camera.setParameters(parameters);
                this.lanternEnable = true;
            } else {
                Log.e((String)this.TAG, (String)"Lantern unsupported");
            }
        }
    }

    public void disableLantern() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setFlashMode("off");
            this.camera.setParameters(parameters);
            this.lanternEnable = false;
        }
    }

    public void enableFaceDetection() {
        if (this.camera != null) {
            this.camera.setFaceDetectionListener((Camera.FaceDetectionListener)this);
        }
    }

    public void onFaceDetection(Camera.Face[] faces, Camera camera) {
    }

    static /* synthetic */ byte[] access$002(Camera1ApiManager x0, byte[] x1) {
        x0.yuvBuffer = x1;
        return x1;
    }
}

