/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.Sprite;
import com.pedro.encoder.input.gl.TextureLoader;
import com.pedro.encoder.input.gl.render.BaseRenderOffScreen;
import com.pedro.encoder.utils.gl.GifStreamObject;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import com.pedro.encoder.utils.gl.TextStreamObject;
import com.pedro.encoder.utils.gl.TranslateTo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

@RequiresApi(api=18)
public class StreamObjectRender
extends BaseRenderOffScreen {
    private final float[] squareVertexData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private FloatBuffer squareVertex;
    private float[] MVPMatrix = new float[16];
    private float[] STMatrix = new float[16];
    private int texId;
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureCameraHandle = -1;
    private int aTextureWatermarkHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int sCameraHandle = -1;
    private int sWatermarkHandle = -1;
    private int uAlphaHandle = -1;
    private FloatBuffer squareVertexWatermark;
    private int[] streamObjectTextureId = null;
    private StreamObjectBase streamObjectBase = null;
    private TextureLoader textureLoader = new TextureLoader();
    private Sprite sprite;
    private float alpha = 1.0f;
    private int encoderWidth;
    private int encoderHeight;

    public StreamObjectRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexData).position(0);
        this.sprite = new Sprite();
        float[] vertices = this.sprite.getTransformedVertices();
        this.squareVertexWatermark = ByteBuffer.allocateDirect(vertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertexWatermark.put(vertices).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    public void initGl(int width, int height, Context context) {
        this.width = width;
        this.height = height;
        GlUtil.checkGlError("initGl start");
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.watermark_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.watermark_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureCameraHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCameraCoord");
        this.aTextureWatermarkHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureWatermarkCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.sCameraHandle = GLES20.glGetUniformLocation((int)this.program, (String)"sCamera");
        this.sWatermarkHandle = GLES20.glGetUniformLocation((int)this.program, (String)"sWatermark");
        this.uAlphaHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uAlpha");
        this.initFBO(width, height);
        GlUtil.checkGlError("initGl end");
    }

    @Override
    public void draw() {
        GlUtil.checkGlError("drawStreamObject start");
        GLES20.glBindFramebuffer((int)36160, (int)this.fboId[0]);
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureCameraHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureCameraHandle);
        this.squareVertexWatermark.position(0);
        GLES20.glVertexAttribPointer((int)this.aTextureWatermarkHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.squareVertexWatermark);
        GLES20.glEnableVertexAttribArray((int)this.aTextureWatermarkHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform1i((int)this.sCameraHandle, (int)2);
        GLES20.glActiveTexture((int)33986);
        GLES20.glBindTexture((int)3553, (int)this.texId);
        GLES20.glUniform1i((int)this.sWatermarkHandle, (int)3);
        GLES20.glActiveTexture((int)33987);
        if (this.streamObjectTextureId != null) {
            if (this.streamObjectTextureId[0] == -1) {
                GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[0]);
                this.streamObjectTextureId = null;
                this.streamObjectBase = null;
            } else {
                GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[this.streamObjectBase.updateFrame()]);
            }
            GLES20.glUniform1f((int)this.uAlphaHandle, (float)this.alpha);
        } else {
            GLES20.glUniform1f((int)this.uAlphaHandle, (float)0.0f);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkGlError("drawStreamObject end");
    }

    @Override
    public void release() {
        this.streamObjectTextureId = null;
        this.streamObjectBase = null;
        this.sprite.reset();
    }

    public void setTexId(int texId) {
        this.texId = texId;
    }

    public void setImage(ImageStreamObject imageStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = imageStreamObject;
        this.textureLoader.setImageStreamObject(imageStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
        this.prepareDefaultSpriteValues();
    }

    public void setText(TextStreamObject textStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = textStreamObject;
        this.textureLoader.setTextStreamObject(textStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
        this.prepareDefaultSpriteValues();
    }

    public void setGif(GifStreamObject gifStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = gifStreamObject;
        this.textureLoader.setGifStreamObject(gifStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
        this.prepareDefaultSpriteValues();
    }

    public void clear() {
        this.streamObjectTextureId = new int[]{-1};
        this.sprite.reset();
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setScale(float scaleX, float scaleY) {
        this.sprite.scale(scaleX, scaleY);
        this.squareVertexWatermark.put(this.sprite.getTransformedVertices()).position(0);
    }

    public void setPosition(float x, float y) {
        this.sprite.translate(x, y);
        this.squareVertexWatermark.put(this.sprite.getTransformedVertices()).position(0);
    }

    public void setPosition(TranslateTo positionTo) {
        this.sprite.translate(positionTo);
        this.squareVertexWatermark.put(this.sprite.getTransformedVertices()).position(0);
    }

    public PointF getScale() {
        return this.sprite.getScale();
    }

    public PointF getPosition() {
        return this.sprite.getTranslation();
    }

    public void setStreamSize(int encoderWidth, int encoderHeight) {
        this.encoderWidth = encoderWidth;
        this.encoderHeight = encoderHeight;
    }

    private void prepareDefaultSpriteValues() {
        this.sprite.scale(this.streamObjectBase.getWidth() * 100 / this.encoderWidth, this.streamObjectBase.getHeight() * 100 / this.encoderHeight);
        this.squareVertexWatermark.put(this.sprite.getTransformedVertices()).position(0);
    }
}

