/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import com.pedro.encoder.input.gl.render.CameraRender;
import com.pedro.encoder.input.gl.render.ScreenRender;
import com.pedro.encoder.input.gl.render.StreamObjectRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import com.pedro.encoder.utils.gl.GifStreamObject;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.TextStreamObject;
import com.pedro.encoder.utils.gl.TranslateTo;

@RequiresApi(api=18)
public class ManagerRender {
    private CameraRender cameraRender = new CameraRender();
    private StreamObjectRender streamObjectRender;
    private BaseFilterRender baseFilterRender = new NoFilterRender();
    private ScreenRender screenRender;
    private int width;
    private int height;
    private Context context;

    public ManagerRender() {
        this.streamObjectRender = new StreamObjectRender();
        this.screenRender = new ScreenRender();
    }

    public void initGl(int width, int height, boolean isCamera2Landscape, Context context) {
        this.width = width;
        this.height = height;
        this.context = context;
        this.cameraRender.isCamera2LandScape(isCamera2Landscape);
        this.cameraRender.initGl(width, height, context);
        this.streamObjectRender.setTexId(this.cameraRender.getTexId());
        this.streamObjectRender.initGl(width, height, context);
        this.baseFilterRender.setTexId(this.streamObjectRender.getTexId());
        this.baseFilterRender.initGl(width, height, context);
        this.baseFilterRender.initFBOLink();
        this.screenRender.setTexId(this.baseFilterRender.getTexId());
        this.screenRender.initGl(context);
    }

    public void drawOffScreen() {
        this.cameraRender.draw();
        this.streamObjectRender.draw();
        this.baseFilterRender.draw();
    }

    public void drawScreen(int width, int height) {
        this.screenRender.draw(width, height);
    }

    public void release() {
        this.cameraRender.release();
        this.streamObjectRender.release();
        this.baseFilterRender.release();
        this.screenRender.release();
    }

    public void updateFrame() {
        this.cameraRender.updateTexImage();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.cameraRender.getSurfaceTexture();
    }

    public Surface getSurface() {
        return this.cameraRender.getSurface();
    }

    public void setFilter(BaseFilterRender baseFilterRender) {
        this.baseFilterRender = baseFilterRender;
        this.baseFilterRender.initGl(this.width, this.height, this.context);
    }

    public void setImage(ImageStreamObject imageStreamObject) {
        this.streamObjectRender.setImage(imageStreamObject);
    }

    public void setText(TextStreamObject textStreamObject) {
        this.streamObjectRender.setText(textStreamObject);
    }

    public void setGif(GifStreamObject gifStreamObject) {
        this.streamObjectRender.setGif(gifStreamObject);
    }

    public void clear() {
        this.streamObjectRender.clear();
    }

    public void setAlpha(float alpha) {
        this.streamObjectRender.setAlpha(alpha);
    }

    public void setScale(float scaleX, float scaleY) {
        this.streamObjectRender.setScale(scaleX, scaleY);
    }

    public void setPosition(float x, float y) {
        this.streamObjectRender.setPosition(x, y);
    }

    public void setPosition(TranslateTo positionTo) {
        this.streamObjectRender.setPosition(positionTo);
    }

    public PointF getScale() {
        return this.streamObjectRender.getScale();
    }

    public PointF getPosition() {
        return this.streamObjectRender.getPosition();
    }

    public void setStreamSize(int encoderWidth, int encoderHeight) {
        this.streamObjectRender.setStreamSize(encoderWidth, encoderHeight);
    }
}

