/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.Sprite;
import com.pedro.encoder.input.gl.TextureLoader;
import com.pedro.encoder.utils.gl.GifStreamObject;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import com.pedro.encoder.utils.gl.TextStreamObject;
import com.pedro.encoder.utils.gl.TranslateTo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

@RequiresApi(api=18)
public class GlWatermarkRenderer {
    public static final String TAG = "TextureManager";
    private Context context;
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int SQUARE_VERTEX_DATA_STRIDE_BYTES = 20;
    private static final int SQUARE_VERTEX_DATA_POS_OFFSET = 0;
    private static final int SQUARE_VERTEX_DATA_UV_OFFSET = 3;
    private final float[] squareVertexData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private final float[] squareVertexData2 = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private final float[] squareVertexDataCamera2LandScape = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f};
    private FloatBuffer squareVertex;
    private FloatBuffer squareVertex2;
    private FloatBuffer squareVertexWatermark;
    private float[] MVPMatrix = new float[16];
    private float[] STMatrix = new float[16];
    private int[] texturesID = new int[1];
    private int program = -1;
    private int textureID = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int aPositionHandle = -1;
    private int aTextureCameraHandle = -1;
    private int aTextureWatermarkHandle = -1;
    private int sWaterMarkHandle = -1;
    private int uAlphaHandle = -1;
    private int program2 = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle2 = -1;
    private int uSTMatrixHandle2 = -1;
    private int aPositionHandle2 = -1;
    private int uSamplerHandle = -1;
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private int[] streamObjectTextureId = null;
    private StreamObjectBase streamObjectBase = null;
    private TextureLoader textureLoader = new TextureLoader();
    private Sprite sprite;
    private float alpha = 1.0f;
    private int encoderWidth;
    private int encoderHeight;
    private final int[] fboId = new int[]{0};
    private final int[] rboId = new int[]{0};
    private final int[] texId = new int[]{0};

    public GlWatermarkRenderer(Context context, boolean isCamera2Landscape) {
        this.context = context;
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        if (isCamera2Landscape) {
            this.squareVertex.put(this.squareVertexDataCamera2LandScape).position(0);
        } else {
            this.squareVertex.put(this.squareVertexData).position(0);
        }
        this.squareVertex2 = ByteBuffer.allocateDirect(this.squareVertexData2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex2.put(this.squareVertexData2).position(0);
        this.sprite = new Sprite();
        float[] vertices = this.sprite.getTransformedVertices();
        this.squareVertexWatermark = ByteBuffer.allocateDirect(vertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertexWatermark.put(vertices).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    public int getTextureId() {
        return this.textureID;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void updateFrame() {
        this.surfaceTexture.updateTexImage();
    }

    public void drawScreen(int width, int height) {
        GlUtil.checkGlError("drawScreen start");
        this.surfaceTexture.getTransformMatrix(this.STMatrix);
        GLES20.glBindFramebuffer((int)36160, (int)this.fboId[0]);
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureCameraHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureCameraHandle);
        this.squareVertexWatermark.position(0);
        GLES20.glVertexAttribPointer((int)this.aTextureWatermarkHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.squareVertexWatermark);
        GLES20.glEnableVertexAttribArray((int)this.aTextureWatermarkHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.textureID);
        GLES20.glUniform1i((int)this.sWaterMarkHandle, (int)1);
        GLES20.glActiveTexture((int)33985);
        if (this.streamObjectTextureId != null) {
            if (this.streamObjectTextureId[0] == -1) {
                GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[0]);
                this.streamObjectTextureId = null;
                this.streamObjectBase = null;
            } else {
                GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[this.streamObjectBase.updateFrame()]);
            }
            GLES20.glUniform1f((int)this.uAlphaHandle, (float)this.alpha);
        } else {
            GLES20.glUniform1f((int)this.uAlphaHandle, (float)0.0f);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkGlError("drawScreen end");
    }

    public void drawEncoder(int width, int height) {
        GlUtil.checkGlError("drawScreen start");
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glUseProgram((int)this.program2);
        this.squareVertex2.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex2);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle2);
        this.squareVertex2.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex2);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle2, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle2, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)3);
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)this.texId[0]);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError("drawScreen end");
    }

    public void initGl(int width, int height) {
        GlUtil.checkGlError("initGl start");
        String vertexShader = GlUtil.getStringFromRaw(this.context, R.raw.watermark_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(this.context, R.raw.watermark_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureCameraHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCameraCoord");
        this.aTextureWatermarkHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureWatermarkCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uAlphaHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uAlpha");
        this.sWaterMarkHandle = GLES20.glGetUniformLocation((int)this.program, (String)"sWatermark");
        GlUtil.createExternalTextures(1, this.texturesID, 0);
        this.textureID = this.texturesID[0];
        this.surfaceTexture = new SurfaceTexture(this.textureID);
        this.surface = new Surface(this.surfaceTexture);
        GlUtil.checkGlError("initGl end");
        this.initFBO(width, height);
    }

    public void initGl2() {
        GlUtil.checkGlError("initGl start");
        String vertexShader = GlUtil.getStringFromRaw(this.context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(this.context, R.raw.simple_fragment);
        this.program2 = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle2 = GLES20.glGetAttribLocation((int)this.program2, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program2, (String)"aTextureCoord");
        this.uMVPMatrixHandle2 = GLES20.glGetUniformLocation((int)this.program2, (String)"uMVPMatrix");
        this.uSTMatrixHandle2 = GLES20.glGetUniformLocation((int)this.program2, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program2, (String)"uSampler");
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)this.texId[0]);
        GlUtil.checkGlError("initGl end");
    }

    private void initFBO(int width, int height) {
        GlUtil.checkGlError("initFBO_S");
        GLES20.glGenFramebuffers((int)1, (int[])this.fboId, (int)0);
        GLES20.glGenRenderbuffers((int)1, (int[])this.rboId, (int)0);
        GLES20.glGenTextures((int)1, (int[])this.texId, (int)0);
        GLES20.glBindRenderbuffer((int)36161, (int)this.rboId[0]);
        GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)width, (int)height);
        GLES20.glBindFramebuffer((int)36160, (int)this.fboId[0]);
        GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.rboId[0]);
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)this.texId[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texId[0], (int)0);
        GlUtil.checkGlError("initFBO_E");
    }

    public void release() {
        this.surfaceTexture = null;
        this.surface = null;
        this.streamObjectTextureId = null;
        this.streamObjectBase = null;
        this.sprite.reset();
    }

    public void setImage(ImageStreamObject imageStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = imageStreamObject;
        this.textureLoader.setImageStreamObject(imageStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
        this.prepareDefaultSpriteValues();
    }

    public void setText(TextStreamObject textStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = textStreamObject;
        this.textureLoader.setTextStreamObject(textStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
        this.prepareDefaultSpriteValues();
    }

    public void setGif(GifStreamObject gifStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = gifStreamObject;
        this.textureLoader.setGifStreamObject(gifStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
        this.prepareDefaultSpriteValues();
    }

    public void clear() {
        this.streamObjectTextureId = new int[]{-1};
        this.sprite.reset();
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setScale(float scaleX, float scaleY) {
        this.sprite.scale(scaleX, scaleY);
        this.squareVertexWatermark.put(this.sprite.getTransformedVertices()).position(0);
    }

    public void setPosition(float x, float y) {
        this.sprite.translate(x, y);
        this.squareVertexWatermark.put(this.sprite.getTransformedVertices()).position(0);
    }

    public void setPosition(TranslateTo positionTo) {
        this.sprite.translate(positionTo);
        this.squareVertexWatermark.put(this.sprite.getTransformedVertices()).position(0);
    }

    public PointF getScale() {
        return this.sprite.getScale();
    }

    public PointF getPosition() {
        return this.sprite.getTranslation();
    }

    private void prepareDefaultSpriteValues() {
        this.sprite.scale(this.streamObjectBase.getWidth() * 100 / this.encoderWidth, this.streamObjectBase.getHeight() * 100 / this.encoderHeight);
        this.squareVertexWatermark.put(this.sprite.getTransformedVertices()).position(0);
    }

    public void setStreamSize(int encoderWidth, int encoderHeight) {
        this.encoderWidth = encoderWidth;
        this.encoderHeight = encoderHeight;
    }
}

