/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.common.base;

import android.util.Log;
import com.pedro.common.BitrateManager;
import com.pedro.common.ConnectChecker;
import com.pedro.common.base.BaseSender;
import com.pedro.common.frame.MediaFrame;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u0011\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010=2\b\u0010?\u001a\u0004\u0018\u00010=H&J\u0018\u0010@\u001a\u00020;2\u0006\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020\rH&J\u000e\u0010C\u001a\u00020;H\u00a4@\u00a2\u0006\u0002\u0010DJ\u0018\u0010E\u001a\u00020;2\b\b\u0002\u0010F\u001a\u00020\rH\u00a4@\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020\u0016J\u0006\u0010J\u001a\u00020;J\u0018\u0010K\u001a\u00020;2\b\b\u0002\u0010F\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010GJ\u0010\u0010L\u001a\u00020\r2\b\b\u0002\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020;2\u0006\u0010P\u001a\u00020\u0013J\u0006\u0010Q\u001a\u00020\u0013J\u0006\u0010R\u001a\u00020\u0013J\u0006\u0010S\u001a\u00020;J\u0006\u0010T\u001a\u00020\u001cJ\u0006\u0010U\u001a\u00020\u001cJ\u0006\u0010V\u001a\u00020;J\u0006\u0010W\u001a\u00020;J\u0006\u0010X\u001a\u00020;J\u0006\u0010Y\u001a\u00020;J\u000e\u0010Z\u001a\u00020;2\u0006\u0010[\u001a\u00020\rJ\u000e\u0010\\\u001a\u00020;2\u0006\u0010]\u001a\u00020NJ\u0006\u0010^\u001a\u00020NR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R$\u0010%\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001e\"\u0004\b'\u0010 R$\u0010(\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001e\"\u0004\b*\u0010 R\u0014\u0010+\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u000f\"\u0004\b0\u0010\u0011R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u000204X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001e\"\u0004\b9\u0010 \u00a8\u0006_"}, d2={"Lcom/pedro/common/base/BaseSender;", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "TAG", "", "<init>", "(Lcom/pedro/common/ConnectChecker;Ljava/lang/String;)V", "getConnectChecker", "()Lcom/pedro/common/ConnectChecker;", "getTAG", "()Ljava/lang/String;", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "cacheSize", "", "queue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/common/frame/MediaFrame;", "getQueue", "()Ljava/util/concurrent/BlockingQueue;", "setQueue", "(Ljava/util/concurrent/BlockingQueue;)V", "audioFramesSent", "", "getAudioFramesSent", "()J", "setAudioFramesSent", "(J)V", "videoFramesSent", "getVideoFramesSent", "setVideoFramesSent", "value", "droppedAudioFrames", "getDroppedAudioFrames", "setDroppedAudioFrames", "droppedVideoFrames", "getDroppedVideoFrames", "setDroppedVideoFrames", "bitrateManager", "Lcom/pedro/common/BitrateManager;", "getBitrateManager", "()Lcom/pedro/common/BitrateManager;", "isEnableLogs", "setEnableLogs", "job", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "bytesSend", "getBytesSend", "setBytesSend", "setVideoInfo", "", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "setAudioInfo", "sampleRate", "isStereo", "onRun", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopImp", "clear", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendMediaFrame", "mediaFrame", "start", "stop", "hasCongestion", "percentUsed", "", "resizeCache", "newSize", "getCacheSize", "getItemsInCache", "clearCache", "getSentAudioFrames", "getSentVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "setLogs", "enable", "setBitrateExponentialFactor", "factor", "getBitrateExponentialFactor", "common_release"})
@SourceDebugExtension(value={"SMAP\nBaseSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSender.kt\ncom/pedro/common/base/BaseSender\n+ 2 Extensions.kt\ncom/pedro/common/ExtensionsKt\n*L\n1#1,147:1\n74#2,5:148\n*S KotlinDebug\n*F\n+ 1 BaseSender.kt\ncom/pedro/common/base/BaseSender\n*L\n49#1:148,5\n*E\n"})
public abstract class BaseSender {
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final String TAG;
    private volatile boolean running;
    private int cacheSize;
    @NotNull
    private volatile BlockingQueue<MediaFrame> queue;
    private long audioFramesSent;
    private long videoFramesSent;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @Nullable
    private Job job;
    @NotNull
    private final CoroutineScope scope;
    private volatile long bytesSend;

    public BaseSender(@NotNull ConnectChecker connectChecker, @NotNull String TAG) {
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)TAG, (String)"TAG");
        this.connectChecker = connectChecker;
        this.TAG = TAG;
        this.cacheSize = 200;
        this.queue = new LinkedBlockingQueue(this.cacheSize);
        this.bitrateManager = new BitrateManager(this.connectChecker);
        this.isEnableLogs = true;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    @NotNull
    protected final ConnectChecker getConnectChecker() {
        return this.connectChecker;
    }

    @NotNull
    protected final String getTAG() {
        return this.TAG;
    }

    protected final boolean getRunning() {
        return this.running;
    }

    protected final void setRunning(boolean bl) {
        this.running = bl;
    }

    @NotNull
    protected final BlockingQueue<MediaFrame> getQueue() {
        return this.queue;
    }

    protected final void setQueue(@NotNull BlockingQueue<MediaFrame> blockingQueue) {
        Intrinsics.checkNotNullParameter(blockingQueue, (String)"<set-?>");
        this.queue = blockingQueue;
    }

    protected final long getAudioFramesSent() {
        return this.audioFramesSent;
    }

    protected final void setAudioFramesSent(long l) {
        this.audioFramesSent = l;
    }

    protected final long getVideoFramesSent() {
        return this.videoFramesSent;
    }

    protected final void setVideoFramesSent(long l) {
        this.videoFramesSent = l;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    protected final void setDroppedAudioFrames(long l) {
        this.droppedAudioFrames = l;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    protected final void setDroppedVideoFrames(long l) {
        this.droppedVideoFrames = l;
    }

    @NotNull
    protected final BitrateManager getBitrateManager() {
        return this.bitrateManager;
    }

    protected final boolean isEnableLogs() {
        return this.isEnableLogs;
    }

    protected final void setEnableLogs(boolean bl) {
        this.isEnableLogs = bl;
    }

    @NotNull
    protected final CoroutineScope getScope() {
        return this.scope;
    }

    protected final long getBytesSend() {
        return this.bytesSend;
    }

    protected final void setBytesSend(long l) {
        this.bytesSend = l;
    }

    public abstract void setVideoInfo(@NotNull ByteBuffer var1, @Nullable ByteBuffer var2, @Nullable ByteBuffer var3);

    public abstract void setAudioInfo(int var1, boolean var2);

    @Nullable
    protected abstract Object onRun(@NotNull Continuation<? super Unit> var1);

    @Nullable
    protected abstract Object stopImp(boolean var1, @NotNull Continuation<? super Unit> var2);

    public static /* synthetic */ Object stopImp$default(BaseSender baseSender, boolean bl, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopImp");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return baseSender.stopImp(bl, (Continuation<? super Unit>)continuation);
    }

    public final void sendMediaFrame(@NotNull MediaFrame mediaFrame) {
        Intrinsics.checkNotNullParameter((Object)mediaFrame, (String)"mediaFrame");
        if (this.running) {
            boolean bl;
            BlockingQueue<MediaFrame> $this$trySend$iv = this.queue;
            boolean $i$f$trySend = false;
            try {
                $this$trySend$iv.add(mediaFrame);
                bl = true;
            }
            catch (IllegalStateException e$iv) {
                bl = false;
            }
            if (!bl) {
                switch (WhenMappings.$EnumSwitchMapping$0[mediaFrame.getType().ordinal()]) {
                    case 1: {
                        Log.i((String)this.TAG, (String)"Video frame discarded");
                        long l = this.droppedVideoFrames;
                        this.droppedVideoFrames = l + 1L;
                        long l2 = l;
                        break;
                    }
                    case 2: {
                        Log.i((String)this.TAG, (String)"Audio frame discarded");
                        long l = this.droppedAudioFrames;
                        this.droppedAudioFrames = l + 1L;
                        long l2 = l;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
    }

    public final void start() {
        this.bitrateManager.reset();
        this.queue.clear();
        this.running = true;
        this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BaseSender this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ BaseSender this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 3 sources

                                        while (CoroutineScopeKt.isActive((CoroutineScope)this.this$0.getScope()) && this.this$0.getRunning()) {
                                            this.label = 1;
                                            v0 = this.this$0.getBitrateManager().calculateBitrate(this.this$0.getBytesSend() * (long)8, (Continuation<? super Unit>)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl15
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        this.this$0.setBytesSend(0L);
                                        this.label = 2;
                                        v1 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                        if (v1 != var2_2) ** GOTO lbl5
                                        return var2_2;
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        ** GOTO lbl5
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.label = 1;
                        Object object3 = this.this$0.onRun((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(boolean var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof stop.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.running = false;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.stopImp(clear != false, (Continuation<? super Unit>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (BaseSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                this.resetSentAudioFrames();
                this.resetSentVideoFrames();
                this.resetDroppedAudioFrames();
                this.resetDroppedVideoFrames();
                v1 = this.job;
                if (v1 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 2;
                v2 = JobKt.cancelAndJoin((Job)v1, (Continuation)$continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                break;
            }
            case 2: {
                this = (BaseSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                break;
            }
        }
        this.job = null;
        this.queue.clear();
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object stop$default(BaseSender baseSender, boolean bl, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stop");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return baseSender.stop(bl, (Continuation<? super Unit>)continuation);
    }

    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        float remaining;
        float capacity;
        if (percentUsed < 0.0f || percentUsed > 100.0f) {
            throw new IllegalArgumentException("the value must be in range 0 to 100");
        }
        float size = this.queue.size();
        return size >= (capacity = size + (remaining = (float)this.queue.remainingCapacity())) * (percentUsed / 100.0f);
    }

    public static /* synthetic */ boolean hasCongestion$default(BaseSender baseSender, float f, int n, Object object) throws IllegalArgumentException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hasCongestion");
        }
        if ((n & 1) != 0) {
            f = 20.0f;
        }
        return baseSender.hasCongestion(f);
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.queue.size() - this.queue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.queue.drainTo(tempQueue);
        this.queue = tempQueue;
    }

    public final int getCacheSize() {
        return this.cacheSize;
    }

    public final int getItemsInCache() {
        return this.queue.size();
    }

    public final void clearCache() {
        this.queue.clear();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    public final void setBitrateExponentialFactor(float factor) {
        this.bitrateManager.setExponentialFactor(factor);
    }

    public final float getBitrateExponentialFactor() {
        return this.bitrateManager.getExponentialFactor();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaFrame.Type.values().length];
            try {
                nArray[MediaFrame.Type.VIDEO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaFrame.Type.AUDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

