/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class URLAccess {
    public String urlLocation;
    public URL url;
    public InputStream inputStream;
    public String errorMessage;

    public static URLAccess doURLAccess(String string) {
        URLAccess uRLAccess = new URLAccess();
        uRLAccess.urlLocation = string;
        try {
            uRLAccess.url = new URL(string);
            PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(uRLAccess.url.openStream()), 1);
            int n = pushbackInputStream.read();
            pushbackInputStream.unread(n);
            uRLAccess.inputStream = pushbackInputStream;
        }
        catch (MalformedURLException malformedURLException) {
            uRLAccess.errorMessage = "Malformed URL";
        }
        catch (FileNotFoundException fileNotFoundException) {
            uRLAccess.errorMessage = "File Not Found";
        }
        catch (UnknownHostException unknownHostException) {
            uRLAccess.errorMessage = "Unknown Host";
        }
        catch (ConnectException connectException) {
            uRLAccess.errorMessage = "Connection Timed Out";
        }
        catch (IOException iOException) {
            uRLAccess.errorMessage = "IO exception";
        }
        return uRLAccess;
    }

    private URLAccess() {
    }

    public void dispose() {
        this.urlLocation = null;
        this.url = null;
        this.errorMessage = null;
        this.closeConnection();
    }

    public void closeConnection() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
        }
    }
}

