/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MacOSAdapter
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(MacOSAdapter.class.toString());
    protected final Object targetObject;
    protected final Method targetMethod;
    protected final String proxySignature;
    protected static Object macOSXApplication;

    public static void setQuitHandler(Object object, Method method) {
        MacOSAdapter.setHandler(new MacOSAdapter("handleQuit", object, method));
    }

    public static void setAboutHandler(Object object, Method method) {
        boolean bl;
        boolean bl2 = bl = object != null && method != null;
        if (bl) {
            MacOSAdapter.setHandler(new MacOSAdapter("handleAbout", object, method));
        }
        try {
            Method method2 = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
            method2.invoke(macOSXApplication, bl);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "MacOSAdapter could not access the About Menu", exception);
        }
    }

    public static void setPreferencesHandler(Object object, Method method) {
        boolean bl;
        boolean bl2 = bl = object != null && method != null;
        if (bl) {
            MacOSAdapter.setHandler(new MacOSAdapter("handlePreferences", object, method));
        }
        try {
            Method method2 = macOSXApplication.getClass().getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            method2.invoke(macOSXApplication, bl);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "MacOSAdapter could not access the About Menu", exception);
        }
    }

    public static void setFileHandler(Object object, Method method) {
        MacOSAdapter.setHandler(new MacOSAdapter("handleOpenFile", object, method){

            @Override
            public boolean callTarget(Object object) {
                if (object != null) {
                    try {
                        Method method = object.getClass().getDeclaredMethod("getFilename", null);
                        String string = (String)method.invoke(object, (Object[])null);
                        this.targetMethod.invoke(this.targetObject, string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
        });
    }

    public static void setHandler(MacOSAdapter macOSAdapter) {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            if (macOSXApplication == null) {
                macOSXApplication = clazz.getConstructor(null).newInstance(null);
            }
            Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationListener");
            Method method = clazz.getDeclaredMethod("addApplicationListener", clazz2);
            Object object = Proxy.newProxyInstance(MacOSAdapter.class.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)macOSAdapter);
            method.invoke(macOSXApplication, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("This version of Mac OS X does not support the Apple EAWT.  ApplicationEvent handling has been disabled (" + String.valueOf(classNotFoundException) + ")");
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Mac OS X Adapter could not talk to EAWT", exception);
        }
    }

    protected MacOSAdapter(String string, Object object, Method method) {
        this.proxySignature = string;
        this.targetObject = object;
        this.targetMethod = method;
    }

    public boolean callTarget(Object object) throws InvocationTargetException, IllegalAccessException {
        Object object2 = this.targetMethod.invoke(this.targetObject, (Object[])null);
        if (object2 == null) {
            return true;
        }
        return Boolean.parseBoolean(object2.toString());
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.isCorrectMethod(method, objectArray)) {
            boolean bl = this.callTarget(objectArray[0]);
            this.setApplicationEventHandled(objectArray[0], bl);
        }
        return null;
    }

    protected boolean isCorrectMethod(Method method, Object[] objectArray) {
        return this.targetMethod != null && this.proxySignature.equals(method.getName()) && objectArray.length == 1;
    }

    protected void setApplicationEventHandled(Object object, boolean bl) {
        if (object != null) {
            try {
                Method method = object.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                method.invoke(object, bl);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "MacOSAdapter was unable to handle an ApplicationEvent", exception);
            }
        }
    }
}

