/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets.annotations;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.GeneralPath;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.PaintButtonInterface;
import org.icepdf.ri.common.widgets.annotations.AnnotationColorButton;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class QuickPaintAnnotationButton
extends AnnotationColorButton {
    private static final Logger logger = Logger.getLogger(QuickPaintAnnotationButton.class.toString());
    private static final GeneralPath textIconPathSmall = new GeneralPath();
    private static final GeneralPath textIconPathLarge;

    public QuickPaintAnnotationButton(Controller controller, ResourceBundle resourceBundle, String string, String string2, String string3, Images.IconSize iconSize, Font font) {
        super(controller, resourceBundle, string, string2, string3, iconSize, font);
        PaintButtonInterface paintButtonInterface = (PaintButtonInterface)((Object)this.colorButton);
        paintButtonInterface.setColorBound(iconSize == Images.IconSize.LARGE ? textIconPathLarge : textIconPathSmall);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.setContentAreaFilled(true);
        Color color = null;
        Preferences preferences = ViewerPropertiesManager.getInstance().getPreferences();
        if (preferences.getInt("application.viewer.utility.annotation.filter.quick.color", -1) != -1) {
            int n = preferences.getInt("application.viewer.utility.annotation.filter.quick.color", 0);
            color = new Color(n);
        }
        if (color != null) {
            paintButtonInterface.setColor(color);
        }
        this.addPropertyChangeListener("annotationQuikcColorPropertyChange", controller);
        this.setupLayout();
    }

    @Override
    public void setColor(Color color, boolean bl) {
        super.setColor(color, bl);
        if (color != null) {
            Preferences preferences = ViewerPropertiesManager.getInstance().getPreferences();
            preferences.putInt("application.viewer.utility.annotation.filter.quick.color", color.getRGB());
            if (bl) {
                this.controller.getDocumentViewController().firePropertyChange("annotationQuikcColorPropertyChange", null, color);
            }
        }
    }

    static {
        textIconPathSmall.moveTo(10.0f, 7.0f);
        textIconPathSmall.lineTo(16.0f, 12.0f);
        textIconPathSmall.lineTo(9.0f, 19.0f);
        textIconPathSmall.lineTo(4.0f, 13.0f);
        textIconPathSmall.closePath();
        textIconPathLarge = new GeneralPath();
        textIconPathLarge.moveTo(14.0f, 10.0f);
        textIconPathLarge.lineTo(21.0f, 16.0f);
        textIconPathLarge.lineTo(12.0f, 26.0f);
        textIconPathLarge.lineTo(5.0f, 18.0f);
        textIconPathLarge.closePath();
    }
}

