/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.listeners;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Logger;
import org.icepdf.core.events.PageImageEvent;
import org.icepdf.core.events.PageInitializingEvent;
import org.icepdf.core.events.PageLoadingEvent;
import org.icepdf.core.events.PageLoadingListener;
import org.icepdf.core.events.PagePaintingEvent;
import org.icepdf.core.pobjects.Page;

public class MetricsPageLoadingListener
implements PageLoadingListener {
    private static final Logger logger = Logger.getLogger(MetricsPageLoadingListener.class.toString());
    public static final DecimalFormat formatter = new DecimalFormat("#.###");
    public static final DecimalFormat percentFormatter = new DecimalFormat("#");
    private int pageIndex;
    private final int pageCount;
    private long startLoading;
    private long endLoading;
    private long startInit;
    private long endInit;
    private long imageCount;
    private long imageLoadDuration;
    private long startPaint;
    private long endPaint;
    private long paintCount;

    public MetricsPageLoadingListener(int n) {
        this.pageCount = n;
    }

    public void pageLoadingStarted(PageLoadingEvent pageLoadingEvent) {
        this.startLoading = System.nanoTime();
        this.pageIndex = ((Page)pageLoadingEvent.getSource()).getPageIndex();
        this.imageCount = pageLoadingEvent.getImageResourceCount();
    }

    public void pageInitializationStarted(PageInitializingEvent pageInitializingEvent) {
        this.startInit = System.nanoTime();
    }

    public void pageInitializationEnded(PageInitializingEvent pageInitializingEvent) {
        this.endInit = System.nanoTime();
    }

    public void pageImageLoaded(PageImageEvent pageImageEvent) {
        this.imageLoadDuration += pageImageEvent.getDuration();
    }

    public void pagePaintingStarted(PagePaintingEvent pagePaintingEvent) {
        this.startPaint = System.nanoTime();
        this.paintCount = pagePaintingEvent.getShapesCount();
    }

    public void pagePaintingEnded(PagePaintingEvent pagePaintingEvent) {
        this.endPaint = System.nanoTime();
    }

    public void pageLoadingEnded(PageLoadingEvent pageLoadingEvent) {
        this.endLoading = System.nanoTime();
        this.displayConsoleMetrics();
    }

    private void displayConsoleMetrics() {
        System.out.println("Loading page: " + (this.pageIndex + 1) + "/" + this.pageCount);
        double d = this.convert(this.endLoading - this.startLoading);
        double d2 = this.convert(this.endInit - this.startInit);
        double d3 = this.convert(this.endPaint - this.startPaint);
        double d4 = this.convert(this.imageLoadDuration);
        System.out.println("        init time: " + formatter.format(d2) + "ms (" + percentFormatter.format(d2 / d * 100.0) + "%)");
        System.out.println("       paint time: " + formatter.format(d3) + "ms (" + percentFormatter.format(d3 / d * 100.0) + "%) " + this.paintCount + " shapes");
        System.out.println("       image time: " + formatter.format(d4) + "ms");
        System.out.println("  avg. image time: " + formatter.format(d4 / (double)this.imageCount) + "ms for " + NumberFormat.getNumberInstance(Locale.US).format(this.imageCount) + " image(s)");
        System.out.println("       total time: " + formatter.format(d));
    }

    private double convert(long l) {
        return (double)l / 1.0E9;
    }
}

