/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.summary;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.annotations.AnnotationPopup;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.summary.AnnotationSummaryBox;
import org.icepdf.ri.common.views.annotations.summary.DraggableAnnotationPanel;

public class SummaryPopupMenu
extends AnnotationPopup<MarkupAnnotationComponent>
implements ItemListener {
    private static final Logger logger = Logger.getLogger(SummaryPopupMenu.class.toString());
    protected final AnnotationSummaryBox annotationSummaryBox;
    protected final MarkupAnnotation markupAnnotation;
    protected final Frame frame;
    protected JCheckBoxMenuItem showHideTextBlockMenuItem;
    protected final DraggableAnnotationPanel.MouseHandler mouseHandler;

    public SummaryPopupMenu(AnnotationSummaryBox annotationSummaryBox, MarkupAnnotation markupAnnotation, MarkupAnnotationComponent markupAnnotationComponent, Controller controller, Frame frame, DraggableAnnotationPanel.MouseHandler mouseHandler) {
        super(markupAnnotationComponent, controller, null);
        this.frame = frame;
        this.markupAnnotation = markupAnnotation;
        this.annotationSummaryBox = annotationSummaryBox;
        this.mouseHandler = mouseHandler;
        this.buildGui();
    }

    @Override
    public void buildGui() {
        this.showHideTextBlockMenuItem = new JCheckBoxMenuItem(this.messageBundle.getString("viewer.annotation.popup.showHidTextBlock.label"));
        this.showHideTextBlockMenuItem.setSelected(this.annotationSummaryBox.isShowTextBlockVisible());
        this.showHideTextBlockMenuItem.addItemListener(this);
        this.add(this.showHideTextBlockMenuItem);
        this.addSeparator();
        this.add(this.deleteMenuItem);
        this.deleteMenuItem.addActionListener(this);
        this.deleteMenuItem.setEnabled(this.controller.havePermissionToModifyDocument());
        this.addSeparator();
        this.add(this.propertiesMenuItem);
        this.propertiesMenuItem.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.propertiesMenuItem) {
            this.controller.showAnnotationProperties(this.annotationComponent, this.frame);
        } else if (object == this.deleteMenuItem) {
            this.controller.getDocumentViewController().deleteAnnotation(this.annotationComponent);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.showHideTextBlockMenuItem) {
            this.annotationSummaryBox.toggleTextBlockVisibility();
            this.annotationSummaryBox.invalidate();
            this.annotationSummaryBox.validate();
            SwingUtilities.invokeLater(() -> this.mouseHandler.checkForOverlap(this.annotationSummaryBox));
        }
    }
}

