/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.summary;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.PageViewComponentImpl;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.summary.DraggableAnnotationPanel;
import org.icepdf.ri.common.views.annotations.summary.SummaryPopupMenu;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class AnnotationSummaryBox
extends PopupAnnotationComponent
implements FocusListener {
    protected boolean showTextBlock = true;

    public AnnotationSummaryBox(PopupAnnotation popupAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(popupAnnotation, documentViewController, abstractPageViewComponent, true);
        this.setFocusable(false);
        this.removeFocusListener(this);
        this.commentPanel.setCursor(Cursor.getPredefinedCursor(13));
        this.commentPanel.removeMouseListener(this.popupListener);
        this.commentPanel.removeMouseListener(this);
        this.commentPanel.removeMouseMotionListener(this);
        this.privateToggleButton.setCursor(Cursor.getPredefinedCursor(0));
        this.minimizeButton.setVisible(false);
        this.textArea.setEditable(true);
        this.textArea.setCursor(Cursor.getPredefinedCursor(2));
        this.commentPanel.getInsets().set(10, 10, 10, 10);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        ViewerPropertiesManager viewerPropertiesManager = documentViewController.getParentController().getPropertiesManager();
        this.setFontSize(viewerPropertiesManager.getPreferences().getInt("application.viewer.annotation.summary.font.size", new JLabel().getFont().getSize()));
        this.removeMouseWheelListener(this);
    }

    public void toggleTextBlockVisibility() {
        this.showTextBlock = !this.showTextBlock;
        this.textArea.setVisible(this.showTextBlock);
    }

    public boolean isShowTextBlockVisible() {
        return this.showTextBlock;
    }

    @Override
    protected void updateContent(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        try {
            if (document.getLength() > 0) {
                this.selectedMarkupAnnotation.setModifiedDate(PDate.formatDateTime((Date)new Date()));
                this.selectedMarkupAnnotation.setContents(document.getText(0, document.getLength()));
                this.documentViewController.updatedSummaryAnnotation(this);
            }
        }
        catch (BadLocationException badLocationException) {
            logger.log(Level.FINE, "Error updating markup annotation content", badLocationException);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.privateToggleButton) {
            boolean bl = this.privateToggleButton.isSelected();
            MarkupAnnotation markupAnnotation = ((PopupAnnotation)this.annotation).getParent();
            if (markupAnnotation != null) {
                markupAnnotation.setFlag(1024, bl);
                markupAnnotation.setModifiedDate(PDate.formatDateTime((Date)new Date()));
                this.documentViewController.updatedSummaryAnnotation(this);
            }
        }
    }

    public Controller getController() {
        return this.documentViewController.getParentController();
    }

    public JPopupMenu getContextMenu(Frame frame, DraggableAnnotationPanel.MouseHandler mouseHandler) {
        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)this.getAnnotationParentComponent();
        if (markupAnnotationComponent == null) {
            int n = ((PopupAnnotation)this.annotation).getParent().getPageIndex();
            PageViewComponentImpl pageViewComponentImpl = (PageViewComponentImpl)this.documentViewController.getParentController().getDocumentViewController().getDocumentViewModel().getPageComponents().get(n);
            pageViewComponentImpl.refreshAnnotationComponents(pageViewComponentImpl.getPage(), false);
            ArrayList<AbstractAnnotationComponent> arrayList = pageViewComponentImpl.getAnnotationComponents();
            for (AbstractAnnotationComponent abstractAnnotationComponent : arrayList) {
                Object t = abstractAnnotationComponent.getAnnotation();
                MarkupAnnotation markupAnnotation = ((PopupAnnotation)this.annotation).getParent();
                if (t == null || markupAnnotation == null || !t.getPObjectReference().equals((Object)markupAnnotation.getPObjectReference())) continue;
                markupAnnotationComponent = (MarkupAnnotationComponent)abstractAnnotationComponent;
                break;
            }
        }
        return new SummaryPopupMenu(this, (MarkupAnnotation)markupAnnotationComponent.getAnnotation(), markupAnnotationComponent, this.documentViewController.getParentController(), frame, mouseHandler);
    }
}

