/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JTextArea;
import javax.swing.plaf.LayerUI;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.ScalableField;

public class ScalableTextArea
extends JTextArea
implements ScalableField {
    private static final long serialVersionUID = 409696785049691125L;
    private boolean active;

    public ScalableTextArea(final DocumentViewModel documentViewModel) {
        this.getDocument().putProperty("i18n", Boolean.TRUE.toString());
        this.putClientProperty("i18n", Boolean.TRUE.toString());
        LayerUI<JComponent> layerUI = new LayerUI<JComponent>(){
            private static final long serialVersionUID = 1155416379916342570L;

            @Override
            public void installUI(JComponent jComponent) {
                super.installUI(jComponent);
                ((JLayer)jComponent).setLayerEventMask(48L);
            }

            @Override
            public void uninstallUI(JComponent jComponent) {
                super.uninstallUI(jComponent);
                ((JLayer)jComponent).setLayerEventMask(0L);
            }

            @Override
            public void eventDispatched(AWTEvent aWTEvent, JLayer<? extends JComponent> jLayer) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                float f = documentViewModel.getViewZoom();
                MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), (int)((float)mouseEvent.getX() / f), (int)((float)mouseEvent.getY() / f), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                mouseEvent.consume();
                ScalableTextArea.this.processMouseEvent(mouseEvent2);
                ScalableTextArea.this.processMouseMotionEvent(mouseEvent2);
            }
        };
        new JLayer<JComponent>(this, layerUI);
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (!this.active) {
            return;
        }
        super.paintBorder(graphics);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.active) {
            return;
        }
        super.paintComponent(graphics);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }
}

