/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.acroform.AdditionalActionsDictionary;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponentImpl;
import org.icepdf.ri.common.views.ResizableBorder;
import org.icepdf.ri.common.views.ResizeableComponent;
import org.icepdf.ri.common.views.annotations.AnnotationState;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public abstract class AbstractAnnotationComponent<T extends Annotation>
extends JComponent
implements FocusListener,
MouseInputListener,
AnnotationComponent,
ResizeableComponent {
    protected static final Logger logger;
    protected static Color annotationHighlightColor;
    protected static float annotationHighlightAlpha;
    protected boolean isSynthetic;
    public static final int resizeBoxSize = 4;
    protected static final ResizableBorder resizableBorder;
    protected PageViewComponentImpl pageViewComponent;
    protected DocumentViewController documentViewController;
    protected float currentZoom;
    protected float currentRotation;
    protected T annotation;
    protected boolean isMousePressed;
    protected boolean resized;
    protected boolean wasResized;
    protected boolean isEditable;
    protected boolean isRollover;
    protected boolean isMovable;
    protected boolean isResizable;
    protected boolean isShowInvisibleBorder;
    protected boolean isSelected;
    protected int dx = 0;
    protected int dy = 0;
    protected int cursor;
    protected Point startPos;
    protected AnnotationState previousAnnotationState;
    protected Point startOfMousePress;
    protected Point endOfMousePress;
    protected JPopupMenu contextMenu;
    protected ResourceBundle messageBundle;

    public AbstractAnnotationComponent(T t, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        this.pageViewComponent = (PageViewComponentImpl)abstractPageViewComponent;
        this.documentViewController = documentViewController;
        this.annotation = t;
        this.messageBundle = documentViewController.getParentController().getMessageBundle();
        this.isEditable = !t.getFlagReadOnly();
        this.isRollover = false;
        this.isMovable = !t.getFlagReadOnly() && !t.getFlagLocked();
        boolean bl = this.isResizable = !t.getFlagReadOnly() && !t.getFlagLocked();
        if (SystemProperties.INTERACTIVE_ANNOTATIONS) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setFocusable(true);
            this.addFocusListener(this);
            this.setLayout(new BorderLayout());
            this.setBorder(resizableBorder);
            DocumentViewModel documentViewModel = documentViewController.getDocumentViewModel();
            Page page = abstractPageViewComponent.getPage();
            AffineTransform affineTransform = page.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
            Rectangle rectangle = Page.convertTo((Rectangle2D)t.getUserSpaceRectangle(), (AffineTransform)affineTransform).getBounds();
            this.setBounds(rectangle);
            this.currentRotation = documentViewModel.getViewRotation();
            this.currentZoom = documentViewModel.getViewZoom();
            resizableBorder.setZoom(this.currentZoom);
        }
    }

    @Override
    public abstract boolean isActive();

    @Override
    public Document getDocument() {
        return this.documentViewController.getDocument();
    }

    @Override
    public int getPageIndex() {
        return this.pageViewComponent.getPageIndex();
    }

    @Override
    public AbstractPageViewComponent getPageViewComponent() {
        return this.pageViewComponent;
    }

    public void removeMouseListeners() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.isSelected = true;
        this.additionalActionsHandler(AdditionalActionsDictionary.ANNOTATION_FO_KEY, null);
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.isSelected = false;
        this.additionalActionsHandler(AdditionalActionsDictionary.ANNOTATION_Bl_KEY, null);
        this.repaint();
    }

    protected void resize() {
        this.resized = true;
    }

    @Override
    public void refreshDirtyBounds() {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        AffineTransform affineTransform = page.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
        this.setBounds(Annotation.commonBoundsNormalization((GeneralPath)new GeneralPath(this.annotation.getUserSpaceRectangle()), (AffineTransform)affineTransform));
    }

    @Override
    public void refreshAnnotationRect() {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        AffineTransform affineTransform = page.getToPageSpaceTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
        Rectangle rectangle = this.getBounds();
        this.annotation.syncBBoxToUserSpaceRectangle((Rectangle2D)Annotation.commonBoundsNormalization((GeneralPath)new GeneralPath(rectangle), (AffineTransform)affineTransform));
    }

    @Override
    public void validate() {
        super.validate();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        if (this.currentZoom != documentViewModel.getViewZoom() || this.currentRotation != documentViewModel.getViewRotation()) {
            this.refreshDirtyBounds();
            this.currentRotation = documentViewModel.getViewRotation();
            this.currentZoom = documentViewModel.getViewZoom();
            resizableBorder.setZoom(this.currentZoom);
        }
        if (this.resized) {
            this.refreshAnnotationRect();
            if (this.getParent() != null) {
                this.getParent().repaint();
            }
            this.resized = false;
            this.wasResized = true;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
    }

    @Override
    public abstract void resetAppearanceShapes();

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.documentViewController.getDocumentViewModel().getViewToolMode();
        if (n == 6 && !this.annotation.getFlagLocked() && !this.annotation.getFlagReadOnly()) {
            Border border = this.getBorder();
            if (border instanceof ResizableBorder) {
                this.setCursor(Cursor.getPredefinedCursor(((ResizableBorder)border).getCursor(mouseEvent)));
            }
        } else {
            this.setCursor(this.documentViewController.getViewCursor(9));
        }
    }

    @Override
    public void dispose() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeFocusListener(this);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.annotation.setCurrentAppearance(Annotation.APPEARANCE_STREAM_NORMAL_KEY);
        this.additionalActionsHandler(AdditionalActionsDictionary.ANNOTATION_X_KEY, mouseEvent);
        this.setCursor(Cursor.getDefaultCursor());
        this.isRollover = false;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Appearance appearance = (Appearance)this.annotation.getAppearances().get(Annotation.APPEARANCE_STREAM_ROLLOVER_KEY);
        if (appearance != null && appearance.hasAlternativeAppearance()) {
            appearance.setSelectedName(appearance.getOnName());
            this.annotation.setCurrentAppearance(Annotation.APPEARANCE_STREAM_ROLLOVER_KEY);
        }
        this.isRollover = this.documentViewController.getDocumentViewModel().getViewToolMode() == 6 || this instanceof PopupAnnotationComponent;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.isMousePressed = true;
        Point point = new Point();
        if (mouseEvent != null) {
            point = mouseEvent.getPoint();
        }
        this.startOfMousePress = point;
        this.endOfMousePress = new Point(point);
        Appearance appearance = (Appearance)this.annotation.getAppearances().get(Annotation.APPEARANCE_STREAM_DOWN_KEY);
        if (appearance != null && appearance.hasAlternativeAppearance()) {
            if (appearance.getSelectedName().equals(appearance.getOnName())) {
                appearance.setSelectedName(appearance.getOffName());
            } else {
                appearance.setSelectedName(appearance.getOnName());
            }
            this.annotation.setCurrentAppearance(Annotation.APPEARANCE_STREAM_DOWN_KEY);
        }
        if (SystemProperties.INTERACTIVE_ANNOTATIONS && !this.annotation.getFlagReadOnly()) {
            this.initiateMouseMoved(mouseEvent);
        }
        this.repaint();
    }

    protected boolean additionalActionsHandler(Name name, MouseEvent mouseEvent) {
        if (!AbstractPageViewComponent.isAnnotationTool(this.documentViewController.getDocumentViewModel().getViewToolMode()) && SystemProperties.INTERACTIVE_ANNOTATIONS && this.documentViewController.getAnnotationCallback() != null) {
            AdditionalActionsDictionary additionalActionsDictionary;
            AbstractWidgetAnnotation abstractWidgetAnnotation;
            FieldDictionary fieldDictionary;
            int n = -1;
            int n2 = -1;
            if (mouseEvent != null) {
                n = mouseEvent.getX();
                n2 = mouseEvent.getY();
            }
            if (this.annotation instanceof AbstractWidgetAnnotation && (fieldDictionary = (abstractWidgetAnnotation = (AbstractWidgetAnnotation)this.annotation).getFieldDictionary()) != null && (additionalActionsDictionary = fieldDictionary.getAdditionalActionsDictionary()) != null && additionalActionsDictionary.isAnnotationValue(name)) {
                this.documentViewController.getAnnotationCallback().processAnnotationAction((Annotation)this.annotation, additionalActionsDictionary.getAction(name), n, n2);
                return true;
            }
        }
        return false;
    }

    protected void initiateMouseMoved(MouseEvent mouseEvent) {
        Border border = this.getBorder();
        if (border instanceof ResizableBorder) {
            this.cursor = ((ResizableBorder)border).getCursor(mouseEvent);
        }
        this.startPos = mouseEvent.getPoint();
        this.previousAnnotationState = new AnnotationState(this, AnnotationState.Operation.MOVE);
        this.documentViewController.assignSelectedAnnotation(this);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.startPos != null && this.isMovable && !this.annotation.getFlagLocked() && !this.annotation.getFlagReadOnly()) {
            int n = this.getX();
            int n2 = this.getY();
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            this.dx = mouseEvent.getX() - this.startPos.x;
            this.dy = mouseEvent.getY() - this.startPos.y;
            if (this.endOfMousePress != null) {
                this.endOfMousePress.setLocation(this.endOfMousePress.x + this.dx, this.endOfMousePress.y + this.dy);
            }
            switch (this.cursor) {
                case 8: {
                    if (!this.isResizable || n4 - this.dy < 12) break;
                    this.setBounds(n, n2 + this.dy, n3, n4 - this.dy);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 9: {
                    if (!this.isResizable || n4 + this.dy < 12) break;
                    this.setBounds(n, n2, n3, n4 + this.dy);
                    this.startPos = mouseEvent.getPoint();
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 10: {
                    if (!this.isResizable || n3 - this.dx < 18) break;
                    this.setBounds(n + this.dx, n2, n3 - this.dx, n4);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 11: {
                    if (!this.isResizable || n3 + this.dx < 18) break;
                    this.setBounds(n, n2, n3 + this.dx, n4);
                    this.startPos = mouseEvent.getPoint();
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 6: {
                    if (!this.isResizable || n3 - this.dx < 18 || n4 - this.dy < 18) break;
                    this.setBounds(n + this.dx, n2 + this.dy, n3 - this.dx, n4 - this.dy);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 7: {
                    if (!this.isResizable || n3 + this.dx < 18 || n4 - this.dy < 18) break;
                    this.setBounds(n, n2 + this.dy, n3 + this.dx, n4 - this.dy);
                    this.startPos = new Point(mouseEvent.getX(), this.startPos.y);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 4: {
                    if (!this.isResizable || n3 - this.dx < 18 || n4 + this.dy < 18) break;
                    this.setBounds(n + this.dx, n2, n3 - this.dx, n4 + this.dy);
                    this.startPos = new Point(this.startPos.x, mouseEvent.getY());
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 5: {
                    if (!this.isResizable || n3 + this.dx < 18 || n4 + this.dy < 18) break;
                    this.setBounds(n, n2, n3 + this.dx, n4 + this.dy);
                    this.startPos = mouseEvent.getPoint();
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                default: {
                    if (!this.isMovable) break;
                    Rectangle rectangle = this.getBounds();
                    rectangle.translate(this.dx, this.dy);
                    this.setBounds(rectangle);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                }
            }
            this.validate();
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.limitAnnotationPosition(n, n2, n3, n4);
        super.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Rectangle limitAnnotationPosition(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.pageViewComponent.getBounds();
        if (!rectangle2.contains(rectangle)) {
            if (rectangle.x < rectangle2.x) {
                rectangle.x = rectangle2.x;
                this.dx = 0;
            }
            if (rectangle.y < rectangle2.y) {
                rectangle.y = rectangle2.y;
                this.dy = 0;
            }
            if (rectangle.x + rectangle.width > rectangle2.width) {
                rectangle.x = rectangle2.width - rectangle.width;
                this.dx = 0;
            }
            if (rectangle.y + rectangle.height > rectangle2.height) {
                rectangle.y = rectangle2.height - rectangle.height;
                this.dy = 0;
            }
            return rectangle;
        }
        return rectangle;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.startPos = null;
        this.isMousePressed = false;
        Appearance appearance = (Appearance)this.annotation.getAppearances().get(Annotation.APPEARANCE_STREAM_DOWN_KEY);
        if (appearance != null && appearance.hasAlternativeAppearance()) {
            if (appearance.getSelectedName().equals(appearance.getOnName())) {
                appearance.setSelectedName(appearance.getOffName());
            } else {
                appearance.setSelectedName(appearance.getOnName());
            }
        }
        this.annotation.setCurrentAppearance(Annotation.APPEARANCE_STREAM_NORMAL_KEY);
        if (this.wasResized) {
            this.wasResized = false;
            this.refreshAnnotationRect();
            double d = 0.0;
            double d2 = 0.0;
            if (this.startOfMousePress != null && this.endOfMousePress != null) {
                d = this.endOfMousePress.getX() - this.startOfMousePress.getX();
                d2 = this.endOfMousePress.getY() - this.startOfMousePress.getY();
            }
            this.annotation.resetAppearanceStream(d, -d2, this.getToPageSpaceTransform(), true);
            this.documentViewController.firePropertyChange("annotationBounds", this, this);
            this.documentViewController.getDocumentViewModel().addMemento(this.previousAnnotationState, new AnnotationState(this, AnnotationState.Operation.MOVE));
            this.previousAnnotationState = null;
            this.documentViewController.updateAnnotation(this);
        }
        if (mouseEvent != null && mouseEvent.getButton() == 1) {
            this.additionalActionsHandler(AdditionalActionsDictionary.ANNOTATION_U_KEY, mouseEvent);
            boolean bl = this.additionalActionsHandler(AdditionalActionsDictionary.ANNOTATION_D_KEY, mouseEvent);
            if (!bl && !AbstractPageViewComponent.isAnnotationTool(this.documentViewController.getDocumentViewModel().getViewToolMode()) && SystemProperties.INTERACTIVE_ANNOTATIONS && this.documentViewController.getAnnotationCallback() != null) {
                Action action = this.annotation.getAction();
                this.documentViewController.getAnnotationCallback().processAnnotationAction((Annotation)this.annotation, action, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        this.repaint();
    }

    public Rectangle convertToPageSpace(Rectangle rectangle) {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.convertToPageSpace(rectangle, documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    protected Shape convertToPageSpace(Shape shape) {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.convertToPageSpace(shape, documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    protected AffineTransform getToPageSpaceTransform() {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.getToPageSpaceTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    protected AffineTransform getPageSpaceTransform() {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isRollover() {
        return this.isRollover;
    }

    @Override
    public boolean isBorderStyle() {
        return this.annotation.isBorder();
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    @Override
    public boolean isMovable() {
        return this.isMovable;
    }

    @Override
    public boolean isResizable() {
        return this.isResizable;
    }

    @Override
    public boolean isShowInvisibleBorder() {
        return this.isShowInvisibleBorder;
    }

    @Override
    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    @Override
    public void setSynthetic(boolean bl) {
        this.isSynthetic = bl;
    }

    static {
        String string;
        block5: {
            logger = Logger.getLogger(AbstractAnnotationComponent.class.toString());
            try {
                string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.highlight.color", (String)"#000000");
                int n = ColorUtil.convertColor((String)string);
                annotationHighlightColor = new Color(n >= 0 ? n : Integer.parseInt("000000", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading page annotation highlight colour");
            }
        }
        try {
            string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.highlight.alpha", (String)"0.4");
            annotationHighlightAlpha = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Error reading page annotation highlight alpha");
            }
            annotationHighlightAlpha = 0.4f;
        }
        resizableBorder = new ResizableBorder(4);
    }
}

