/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Arrays;
import org.icepdf.ri.common.views.BasePageViewLayout;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewDecorator;

public class TwoPageViewLayout
extends BasePageViewLayout
implements LayoutManager2 {
    protected int minWidth = 0;
    protected int minHeight = 0;
    protected int preferredWidth = 0;
    protected int preferredHeight = 0;
    protected boolean sizeUnknown = true;
    protected int viewType;

    public TwoPageViewLayout(int n, DocumentViewModel documentViewModel) {
        super(documentViewModel);
        this.viewType = n;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getWidth() - (insets.left + insets.right);
        int n2 = container.getHeight() - (insets.top + insets.bottom);
        int n3 = 0;
        int n4 = 0;
        if (this.sizeUnknown) {
            this.setSizes(container);
        }
        PageViewDecorator[] pageViewDecoratorArray = (PageViewDecorator[])Arrays.stream(container.getComponents()).filter(component -> component instanceof PageViewDecorator && component.isVisible()).toArray(PageViewDecorator[]::new);
        int n5 = 0;
        int n6 = 0;
        for (PageViewDecorator pageViewDecorator : pageViewDecoratorArray) {
            int n7 = pageViewDecorator.getPageViewComponent().getPageIndex();
            Dimension dimension = pageViewDecorator.getPreferredSize();
            if (this.viewType == 1 && n7 == 0 && pageViewDecoratorArray.length == 1) {
                n3 = (n - this.preferredWidth) / 2 + dimension.width + 2;
                n3 += insets.left;
            } else if (n5 == 0) {
                n3 += (n - this.preferredWidth) / 2;
                n3 += insets.left;
                n6 = dimension.width;
                ++n5;
            } else {
                n3 += n6 + 2;
            }
            n4 = (n2 - dimension.height) / 2;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            pageViewDecorator.setBounds(n3, n4 += insets.top, dimension.width, dimension.height);
            this.updatePopupAnnotationComponents(pageViewDecorator);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        this.setSizes(container);
        Insets insets = container.getInsets();
        dimension.width = this.preferredWidth + insets.left + insets.right;
        dimension.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Insets insets = container.getInsets();
        dimension.width = this.minWidth + insets.left + insets.right;
        dimension.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return null;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    protected void setSizes(Container container) {
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        PageViewDecorator[] pageViewDecoratorArray = (PageViewDecorator[])Arrays.stream(container.getComponents()).filter(component -> component instanceof PageViewDecorator && component.isVisible()).toArray(PageViewDecorator[]::new);
        for (int i = 0; i < pageViewDecoratorArray.length; ++i) {
            PageViewDecorator pageViewDecorator = pageViewDecoratorArray[i];
            Dimension dimension = ((Component)pageViewDecorator).getPreferredSize();
            this.preferredWidth = Math.max(dimension.width * 2 + 2, this.preferredWidth);
            this.preferredHeight = Math.max(dimension.height + 2, this.preferredHeight);
            this.minWidth = Math.max(((Component)pageViewDecorator).getMinimumSize().width * 2, this.minWidth);
            this.minHeight = this.preferredHeight;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

