/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.icepdf.ri.common.KeyListenerPageChanger;
import org.icepdf.ri.common.MouseWheelListenerPageChanger;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.OnePageViewLayout;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewDecorator;

public class OnePageView
extends AbstractDocumentView {
    protected final Object pageChangerListener;
    protected final KeyListenerPageChanger keyListenerPageChanger;

    public OnePageView(DocumentViewController documentViewController, JScrollPane jScrollPane, DocumentViewModel documentViewModel) {
        super(documentViewController, jScrollPane, documentViewModel);
        this.buildGUI();
        this.pageChangerListener = MouseWheelListenerPageChanger.install(this.documentViewController.getParentController(), jScrollPane, this);
        this.keyListenerPageChanger = KeyListenerPageChanger.install(this.documentViewController.getParentController(), jScrollPane, this);
    }

    private void buildGUI() {
        this.setLayout(new OnePageViewLayout(this.documentViewModel));
        this.setBackground(backgroundColour);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.updateDocumentView();
    }

    @Override
    public void updateDocumentView() {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        List<AbstractPageViewComponent> list = documentViewModel.getPageComponents();
        if (list != null) {
            AbstractPageViewComponent abstractPageViewComponent = list.get(documentViewModel.getViewCurrentPageIndex());
            if (abstractPageViewComponent != null) {
                this.removeAll();
                JComponent jComponent = this.buildPageDecoration(abstractPageViewComponent);
                this.setLayer(jComponent, JLayeredPane.DEFAULT_LAYER);
                this.add(jComponent);
                this.addPopupAnnotationAndGlue(abstractPageViewComponent);
            }
            for (PageViewComponent pageViewComponent : list) {
                if (pageViewComponent == null) continue;
                pageViewComponent.setDocumentViewCallback(this);
            }
            this.revalidate();
            this.repaint();
        }
    }

    protected JComponent buildPageDecoration(AbstractPageViewComponent abstractPageViewComponent) {
        return new PageViewDecorator(abstractPageViewComponent);
    }

    @Override
    public int getNextPageIncrement() {
        return 1;
    }

    @Override
    public int getPreviousPageIncrement() {
        return 1;
    }

    @Override
    public void dispose() {
        if (this.pageChangerListener != null) {
            JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
            MouseWheelListenerPageChanger.uninstall(jScrollPane, this.pageChangerListener);
        }
        if (this.keyListenerPageChanger != null) {
            this.keyListenerPageChanger.uninstall();
        }
        super.dispose();
    }

    @Override
    public Dimension getDocumentSize() {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = this.documentViewController.getCurrentPageIndex();
        Rectangle rectangle = this.documentViewModel.getPageBounds(n);
        if (rectangle != null) {
            f = rectangle.width;
            f2 = rectangle.height;
        }
        float f3 = this.documentViewController.getDocumentViewModel().getViewZoom();
        f = Math.abs(f / f3);
        f2 = Math.abs(f2 / f3);
        return new Dimension((int)(f += 2.0f), (int)(f2 += 4.0f));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(backgroundColour);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paintComponent(graphics);
    }
}

