/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.icepdf.ri.common.CurrentPageChanger;
import org.icepdf.ri.common.KeyListenerPageColumnChanger;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.OneColumnPageViewLayout;
import org.icepdf.ri.common.views.PageViewDecorator;

public class OneColumnPageView
extends AbstractDocumentView {
    protected final CurrentPageChanger currentPageChanger;
    protected final KeyListenerPageColumnChanger keyListenerPageChanger;

    public OneColumnPageView(DocumentViewController documentViewController, JScrollPane jScrollPane, DocumentViewModel documentViewModel) {
        super(documentViewController, jScrollPane, documentViewModel);
        this.buildGUI();
        this.currentPageChanger = new CurrentPageChanger(jScrollPane, this, documentViewModel.getPageComponents());
        this.keyListenerPageChanger = KeyListenerPageColumnChanger.install(this.documentViewController.getParentController(), documentViewModel.getDocumentViewScrollPane(), this, this.currentPageChanger);
    }

    private void buildGUI() {
        this.setLayout(new OneColumnPageViewLayout(this.documentViewModel));
        this.setBackground(backgroundColour);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        List<AbstractPageViewComponent> list = this.documentViewController.getDocumentViewModel().getPageComponents();
        if (list != null) {
            for (AbstractPageViewComponent abstractPageViewComponent : list) {
                if (abstractPageViewComponent == null) continue;
                abstractPageViewComponent.setDocumentViewCallback(this);
                PageViewDecorator pageViewDecorator = new PageViewDecorator(abstractPageViewComponent);
                this.setLayer(pageViewDecorator, JLayeredPane.DEFAULT_LAYER);
                this.add(pageViewDecorator);
                this.addPopupAnnotationAndGlue(abstractPageViewComponent);
            }
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void updateDocumentView() {
    }

    @Override
    public int getNextPageIncrement() {
        return 1;
    }

    @Override
    public int getPreviousPageIncrement() {
        return 1;
    }

    @Override
    public void dispose() {
        if (this.currentPageChanger != null) {
            this.currentPageChanger.dispose();
        }
        if (this.keyListenerPageChanger != null) {
            this.keyListenerPageChanger.uninstall();
        }
        this.removeAll();
        this.invalidate();
        super.dispose();
    }

    @Override
    public Dimension getDocumentSize() {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = this.documentViewController.getCurrentPageIndex();
        Rectangle rectangle = this.documentViewModel.getPageBounds(n);
        if (rectangle != null) {
            f = rectangle.width;
            f2 = rectangle.height;
        }
        float f3 = this.documentViewController.getDocumentViewModel().getViewZoom();
        f = Math.abs(f / f3);
        f2 = Math.abs(f2 / f3);
        return new Dimension((int)(f += 2.0f), (int)(f2 += 4.0f));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(backgroundColour);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paintComponent(graphics);
    }
}

