/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.OnePageView;
import org.icepdf.ri.common.views.PageViewDecorator;
import org.icepdf.ri.util.Resources;

public class FullScreenDocumentView
extends OnePageView
implements WindowListener {
    private static final Logger logger = Logger.getLogger(FullScreenDocumentView.class.toString());
    private static Object instance;
    private boolean disposed;
    private GraphicsDevice defaultScreenDevice;
    private final DocumentViewController controller;
    private JFrame frame;

    public FullScreenDocumentView(DocumentViewController documentViewController) {
        super(documentViewController, new JScrollPane(), documentViewController.getDocumentViewModel());
        this.controller = documentViewController;
    }

    public void display() {
        if (instance != null) {
            logger.warning("Only one full screen view is allowed at a time.");
            return;
        }
        instance = this;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.defaultScreenDevice = graphicsEnvironment.getDefaultScreenDevice();
        if (this.defaultScreenDevice != null && this.defaultScreenDevice.isFullScreenSupported()) {
            final FullScreenDocumentView fullScreenDocumentView = this;
            this.frame = new JFrame(){

                @Override
                protected JRootPane createRootPane() {
                    ActionListener actionListener = actionEvent -> fullScreenDocumentView.dispose();
                    JRootPane jRootPane = new JRootPane();
                    KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
                    jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
                    return jRootPane;
                }
            };
            this.frame.addWindowListener(this);
            this.frame.setUndecorated(true);
            this.buildFullScreenDocumentView();
            this.defaultScreenDevice.setFullScreenWindow(this.frame);
        } else {
            ResourceBundle resourceBundle = this.documentViewController.getParentController().getMessageBundle();
            Resources.showMessageDialog(this.documentViewController.getViewContainer(), 1, resourceBundle, "viewer.dialog.fullScreen.error.title", "viewer.dialog.fullScreen.error.msg");
        }
    }

    @Override
    protected JComponent buildPageDecoration(AbstractPageViewComponent abstractPageViewComponent) {
        return new FullScreenPageViewDecorator(abstractPageViewComponent);
    }

    private void buildFullScreenDocumentView() {
        JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.setBackground(Color.BLACK);
        jScrollPane.getViewport().setBackground(Color.BLACK);
        jScrollPane.setViewportView(this);
        this.frame.setBackground(Color.BLACK);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.frame.setContentPane(jScrollPane);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        super.dispose();
        try {
            this.controller.revertViewType();
            this.defaultScreenDevice.setFullScreenWindow(null);
        }
        finally {
            this.frame.setVisible(false);
            this.frame.dispose();
            instance = null;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(Color.BLACK);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    private static class FullScreenPageViewDecorator
    extends PageViewDecorator {
        public FullScreenPageViewDecorator(JComponent jComponent) {
            super(jComponent);
        }

        @Override
        protected void paintBorder(Graphics2D graphics2D, Dimension dimension) {
        }

        @Override
        protected void paintShadow(Graphics2D graphics2D, Dimension dimension) {
        }
    }
}

