/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.images.ImageUtility;
import org.icepdf.core.util.Library;
import org.icepdf.ri.viewer.WindowManager;

public class DocumentViewComponent
extends JComponent
implements MouseListener,
Runnable {
    private static final Logger logger = Logger.getLogger(DocumentViewComponent.class.toString());
    private static final long serialVersionUID = -8881023489246309889L;
    private final Library parentLibrary;
    private final Reference fileReference;
    private final String fileName;
    private boolean isPdfDocument;
    public static final String PDF_EXTENSION = ".pdf";
    private static final int minimumThumbHeight = 110;
    private static final int minimumThumbWidth = 85;
    private Dimension pageSize = new Dimension(85, 110);
    private SoftReference<BufferedImage> documentThumbNail = new SoftReference<Object>(null);

    public DocumentViewComponent(Library library, String string, Reference reference) {
        this.parentLibrary = library;
        this.fileName = string;
        this.fileReference = reference;
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.isPdfDocument = string.toLowerCase().endsWith(PDF_EXTENSION);
        if (this.isPdfDocument) {
            Library.execute((Runnable)this);
        }
    }

    @Override
    public void run() {
        try {
            Stream stream = (Stream)this.parentLibrary.getObject(this.fileReference);
            ByteArrayInputStream byteArrayInputStream = stream.getDecodedByteArrayInputStream();
            Document document = new Document();
            document.setInputStream((InputStream)byteArrayInputStream, this.fileName);
            Page page = document.getPageTree().getPage(0);
            page.init();
            PDimension pDimension = page.getSize(2, 0.0f, 1.0f);
            float f = 110.0f / (float)pDimension.getHeight();
            this.pageSize = page.getSize(2, 0.0f, f).toDimension();
            int n = (int)this.pageSize.getWidth();
            int n2 = (int)this.pageSize.getHeight();
            BufferedImage bufferedImage = ImageUtility.createTranslucentCompatibleImage((int)n, (int)n2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            page.paint((Graphics)graphics2D, 2, 2, 0.0f, f);
            graphics2D.dispose();
            this.documentThumbNail = new SoftReference<BufferedImage>(bufferedImage);
            SwingUtilities.invokeLater(() -> {
                this.revalidate();
                this.repaint();
            });
            document.dispose();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to load embedded PDF and build thumbnail", exception);
            this.isPdfDocument = false;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        BufferedImage bufferedImage = this.documentThumbNail.get();
        if (bufferedImage != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pageSize;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.isPdfDocument) {
            try {
                Stream stream = (Stream)this.parentLibrary.getObject(this.fileReference);
                ByteArrayInputStream byteArrayInputStream = stream.getDecodedByteArrayInputStream();
                Document document = new Document();
                document.setInputStream((InputStream)byteArrayInputStream, this.fileName);
                WindowManager.getInstance().newWindow(document, this.fileName);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to launch embedded PDF", exception);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

