/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JScrollPane;
import org.icepdf.core.CombinedMemento;
import org.icepdf.core.Memento;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.ri.common.UndoCaretaker;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationState;
import org.icepdf.ri.common.views.annotations.MarkupGlueComponent;
import org.icepdf.ri.common.views.annotations.PageViewAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public abstract class AbstractDocumentViewModel
implements DocumentViewModel {
    private static final Logger log = Logger.getLogger(AbstractDocumentViewModel.class.toString());
    protected final Document currentDocument;
    protected DocumentView documentView;
    private HashMap<Integer, AbstractPageViewComponent> selectedPageText;
    private boolean selectAll;
    protected List<AbstractPageViewComponent> pageComponents;
    protected HashMap<AbstractPageViewComponent, ArrayList<PageViewAnnotationComponent>> documentViewAnnotationComponents;
    protected JScrollPane documentViewScrollPane;
    protected final UndoCaretaker undoCaretaker;
    protected AnnotationComponent currentAnnotation;
    protected float userZoom = 1.0f;
    protected float oldUserZoom = 1.0f;
    protected float userRotation;
    protected float oldUserRotation;
    protected int currentPageIndex;
    protected int oldPageIndex;
    protected int pageBoundary = 2;
    protected int userToolModeFlag;
    protected int oldUserToolModeFlag;
    protected static final int MAX_PAGE_SIZE_READ_AHEAD = 10;

    public AbstractDocumentViewModel(Document document) {
        this.currentDocument = document;
        this.undoCaretaker = new UndoCaretaker();
        this.documentViewAnnotationComponents = new HashMap();
    }

    protected abstract AbstractPageViewComponent buildPageViewComponent(DocumentViewModel var1, PageTree var2, int var3, int var4, int var5);

    @Override
    public Document getDocument() {
        return this.currentDocument;
    }

    @Override
    public List<AbstractPageViewComponent> getPageComponents() {
        return this.pageComponents;
    }

    @Override
    public HashMap<AbstractPageViewComponent, ArrayList<PageViewAnnotationComponent>> getDocumentViewAnnotationComponents() {
        return this.documentViewAnnotationComponents;
    }

    @Override
    public ArrayList<PageViewAnnotationComponent> getDocumentViewAnnotationComponents(AbstractPageViewComponent abstractPageViewComponent) {
        return this.documentViewAnnotationComponents.get(abstractPageViewComponent);
    }

    @Override
    public void addDocumentViewAnnotationComponent(AbstractPageViewComponent abstractPageViewComponent, PageViewAnnotationComponent pageViewAnnotationComponent) {
        if (!this.documentViewAnnotationComponents.containsKey(abstractPageViewComponent)) {
            this.documentViewAnnotationComponents.put(abstractPageViewComponent, new ArrayList());
        }
        List list = this.documentViewAnnotationComponents.get(abstractPageViewComponent);
        list.add(pageViewAnnotationComponent);
    }

    @Override
    public void removeDocumentViewAnnotationComponent(DocumentView documentView, AbstractPageViewComponent abstractPageViewComponent, PageViewAnnotationComponent pageViewAnnotationComponent) {
        if (this.documentViewAnnotationComponents.containsKey(abstractPageViewComponent)) {
            List list = this.documentViewAnnotationComponents.get(abstractPageViewComponent);
            list.remove(pageViewAnnotationComponent);
            if (pageViewAnnotationComponent instanceof PopupAnnotationComponent) {
                PageViewAnnotationComponent pageViewAnnotationComponent2 = null;
                for (PageViewAnnotationComponent pageViewAnnotationComponent3 : list) {
                    Reference reference;
                    if (!(pageViewAnnotationComponent3 instanceof MarkupGlueComponent)) continue;
                    MarkupGlueComponent markupGlueComponent = (MarkupGlueComponent)pageViewAnnotationComponent3;
                    PopupAnnotationComponent popupAnnotationComponent = (PopupAnnotationComponent)pageViewAnnotationComponent;
                    Reference reference2 = ((PopupAnnotation)markupGlueComponent.getPopupAnnotationComponent().getAnnotation()).getPObjectReference();
                    if (!reference2.equals((Object)(reference = ((PopupAnnotation)popupAnnotationComponent.getAnnotation()).getPObjectReference()))) continue;
                    pageViewAnnotationComponent2 = pageViewAnnotationComponent3;
                    break;
                }
                if (pageViewAnnotationComponent2 != null) {
                    list.remove(pageViewAnnotationComponent2);
                    documentView.remove((Component)((Object)pageViewAnnotationComponent2));
                }
            }
        }
    }

    @Override
    public void removeAllFloatingAnnotationComponent(AbstractPageViewComponent abstractPageViewComponent) {
        this.documentViewAnnotationComponents.remove(abstractPageViewComponent);
    }

    public void removeFloatingAnnotationComponent(AbstractAnnotationComponent abstractAnnotationComponent) {
        this.documentViewAnnotationComponents.remove(abstractAnnotationComponent);
    }

    @Override
    public boolean setViewCurrentPageIndex(int n) {
        boolean bl = n != this.currentPageIndex;
        this.oldPageIndex = this.currentPageIndex;
        this.currentPageIndex = n;
        return bl;
    }

    @Override
    public int getViewCurrentPageIndex() {
        return this.currentPageIndex;
    }

    @Override
    public ArrayList<AbstractPageViewComponent> getSelectedPageText() {
        if (this.selectedPageText != null) {
            Set<Integer> set = this.selectedPageText.keySet();
            ArrayList<AbstractPageViewComponent> arrayList = new ArrayList<AbstractPageViewComponent>(set.size());
            for (Integer n : set) {
                arrayList.add(this.selectedPageText.get(n));
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public boolean isSelectAll() {
        return this.selectAll;
    }

    @Override
    public void setSelectAll(boolean bl) {
        this.selectAll = bl;
    }

    @Override
    public void addSelectedPageText(AbstractPageViewComponent abstractPageViewComponent) {
        if (this.selectedPageText == null) {
            this.selectedPageText = new HashMap();
        }
        this.selectedPageText.put(abstractPageViewComponent.getPageIndex(), abstractPageViewComponent);
    }

    @Override
    public void removeSelectedPageText(AbstractPageViewComponent abstractPageViewComponent) {
        if (this.selectedPageText == null) {
            this.selectedPageText = new HashMap();
        }
        this.selectedPageText.remove(abstractPageViewComponent.getPageIndex());
    }

    @Override
    public void clearSelectedPageText() {
        if (this.selectedPageText != null) {
            this.selectedPageText.clear();
        }
        this.selectAll = false;
    }

    @Override
    public boolean setViewZoom(float f) {
        boolean bl;
        boolean bl2 = bl = this.userZoom != f;
        if (bl) {
            this.oldUserZoom = this.userZoom;
            this.userZoom = f;
        }
        return bl;
    }

    @Override
    public float getViewZoom() {
        return this.userZoom;
    }

    @Override
    public boolean setViewRotation(float f) {
        boolean bl;
        boolean bl2 = bl = this.userRotation != f;
        if (bl) {
            this.oldUserRotation = this.userRotation;
            this.userRotation = f;
        }
        return bl;
    }

    @Override
    public float getViewRotation() {
        return this.userRotation;
    }

    @Override
    public boolean setViewToolMode(int n) {
        boolean bl;
        boolean bl2 = bl = n != this.userToolModeFlag;
        if (bl) {
            this.oldUserToolModeFlag = this.userToolModeFlag;
            this.userToolModeFlag = n;
        }
        return bl;
    }

    @Override
    public int getViewToolMode() {
        return this.userToolModeFlag;
    }

    @Override
    public boolean isViewToolModeSelected(int n) {
        return this.userToolModeFlag == n;
    }

    @Override
    public void setPageBoundary(int n) {
        this.pageBoundary = n;
    }

    @Override
    public int getPageBoundary() {
        return this.pageBoundary;
    }

    @Override
    public Rectangle getPageBounds(int n) {
        Component component;
        if (this.pageComponents != null && n < this.pageComponents.size() && (component = (Component)this.pageComponents.get(n)) != null && component.getParent() != null) {
            Rectangle rectangle = component.getParent().getBounds();
            return rectangle;
        }
        return new Rectangle();
    }

    @Override
    public void dispose() {
        if (this.pageComponents != null) {
            for (AbstractPageViewComponent abstractPageViewComponent : this.pageComponents) {
                if (abstractPageViewComponent == null) continue;
                abstractPageViewComponent.dispose();
            }
            this.pageComponents.clear();
        }
        if (this.documentViewAnnotationComponents != null) {
            this.documentViewAnnotationComponents.clear();
        }
    }

    @Override
    public AnnotationComponent getCurrentAnnotation() {
        return this.currentAnnotation;
    }

    @Override
    public void setCurrentAnnotation(AnnotationComponent annotationComponent) {
        if (this.currentAnnotation != null) {
            this.currentAnnotation.setSelected(false);
            this.currentAnnotation.repaint();
        }
        this.currentAnnotation = annotationComponent;
        if (this.currentAnnotation != null) {
            this.currentAnnotation.setSelected(true);
        }
    }

    public DocumentView getDocumentView() {
        return this.documentView;
    }

    public void setDocumentView(DocumentView documentView) {
        this.documentView = documentView;
    }

    @Override
    public JScrollPane getDocumentViewScrollPane() {
        return this.documentViewScrollPane;
    }

    @Override
    public void setDocumentViewScrollPane(JScrollPane jScrollPane) {
        this.documentViewScrollPane = jScrollPane;
    }

    @Override
    public UndoCaretaker getAnnotationCareTaker() {
        return this.undoCaretaker;
    }

    @Override
    public void addMemento(Memento memento, Memento memento2) {
        Memento memento3 = this.filterMemento(memento);
        Memento memento4 = this.filterMemento(memento2);
        if (memento3 != null && memento4 != null) {
            this.undoCaretaker.addState(memento3, memento4);
        }
    }

    private Memento filterMemento(Memento memento) {
        if (memento instanceof AnnotationState) {
            AnnotationState annotationState = (AnnotationState)memento;
            if (annotationState.getOperation() == AnnotationState.Operation.MOVE || !(annotationState.getAnnotationComponent() instanceof PopupAnnotationComponent)) {
                return memento;
            }
            return null;
        }
        if (memento instanceof CombinedMemento) {
            CombinedMemento combinedMemento = new CombinedMemento(((CombinedMemento)memento).getMementos().stream().map(this::filterMemento).filter(Objects::nonNull).collect(Collectors.toList()));
            if (combinedMemento.getMementos().isEmpty()) {
                return null;
            }
            return combinedMemento;
        }
        return memento;
    }
}

