/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.tools.AnnotationSelectionHandler;
import org.icepdf.ri.common.tools.DynamicZoomHandler;
import org.icepdf.ri.common.tools.HighLightAnnotationHandler;
import org.icepdf.ri.common.tools.MouseWheelZoom;
import org.icepdf.ri.common.tools.PanningHandler;
import org.icepdf.ri.common.tools.TextSelectionPageHandler;
import org.icepdf.ri.common.tools.TextSelectionViewHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.tools.ZoomInViewHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.MarkupGlueComponent;
import org.icepdf.ri.common.views.annotations.PageViewAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.destinations.DestinationComponent;

public abstract class AbstractDocumentView
extends JLayeredPane
implements DocumentView,
PropertyChangeListener,
MouseListener,
MouseMotionListener,
ActionListener {
    private static final Logger logger;
    public static Color backgroundColour;
    private static int SCROLL_REFRESH_DELAY;
    private final Timer autoScrollTimer;
    private Point lastMouseLocation;
    public static final int verticalSpace = 2;
    public static final int horizontalSpace = 1;
    public static final int layoutInserts = 2;
    protected DocumentViewController documentViewController;
    protected DocumentViewModel documentViewModel;
    protected ToolHandler currentTool;
    protected MouseWheelZoom mouseWheelZoom;

    public AbstractDocumentView(DocumentViewController documentViewController, JScrollPane jScrollPane, DocumentViewModel documentViewModel) {
        this.documentViewController = documentViewController;
        this.documentViewModel = documentViewModel;
        documentViewModel.setDocumentViewScrollPane(jScrollPane);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mouseWheelZoom = new MouseWheelZoom(documentViewController, jScrollPane);
        jScrollPane.addMouseWheelListener(this.mouseWheelZoom);
        this.autoScrollTimer = new Timer(SCROLL_REFRESH_DELAY, this);
        this.autoScrollTimer.setInitialDelay(50);
        documentViewController.getHorizontalScrollBar().addAdjustmentListener(this);
        documentViewController.getVerticalScrollBar().addAdjustmentListener(this);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        if ("focusOwner".equals(string)) {
            DocumentViewController documentViewController = this.getParentViewController();
            if (object instanceof AnnotationComponent) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Selected Annotation " + String.valueOf(object));
                }
                documentViewController.firePropertyChange("annotationFocusGained", object2, object);
            } else if (object instanceof DestinationComponent) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Selected destination " + String.valueOf(object));
                }
                documentViewController.firePropertyChange("destinationFocusGained", object2, object);
            }
        }
    }

    @Override
    public DocumentViewController getParentViewController() {
        return this.documentViewController;
    }

    @Override
    public DocumentViewModel getViewModel() {
        return this.documentViewController.getDocumentViewModel();
    }

    protected void addPopupAnnotationAndGlue(AbstractPageViewComponent abstractPageViewComponent) {
        ArrayList<PageViewAnnotationComponent> arrayList = this.documentViewModel.getDocumentViewAnnotationComponents(abstractPageViewComponent);
        if (arrayList != null) {
            for (PageViewAnnotationComponent pageViewAnnotationComponent : arrayList) {
                JComponent jComponent;
                if (pageViewAnnotationComponent instanceof MarkupGlueComponent) {
                    jComponent = (MarkupGlueComponent)pageViewAnnotationComponent;
                    this.setLayer(jComponent, JLayeredPane.MODAL_LAYER);
                    this.add(jComponent);
                }
                if (!(pageViewAnnotationComponent instanceof PopupAnnotationComponent)) continue;
                jComponent = (PopupAnnotationComponent)pageViewAnnotationComponent;
                this.setLayer(jComponent, JLayeredPane.POPUP_LAYER);
                this.add(jComponent);
            }
        }
    }

    @Override
    public void dispose() {
        this.documentViewController.getHorizontalScrollBar().removeAdjustmentListener(this);
        this.documentViewController.getVerticalScrollBar().removeAdjustmentListener(this);
        if (this.currentTool != null) {
            this.removeMouseListener(this.currentTool);
            this.removeMouseMotionListener(this.currentTool);
        }
        this.documentViewModel.getDocumentViewScrollPane().removeMouseWheelListener(this.mouseWheelZoom);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.autoScrollTimer.stop();
        this.removeFocusListener(this);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.removePropertyChangeListener(this);
        this.removeAll();
        this.invalidate();
    }

    @Override
    public abstract void updateDocumentView();

    @Override
    public ToolHandler uninstallCurrentTool() {
        if (this.currentTool != null) {
            this.currentTool.uninstallTool();
            this.removeMouseListener(this.currentTool);
            this.removeMouseMotionListener(this.currentTool);
            if (this.currentTool instanceof TextSelectionViewHandler) {
                this.documentViewModel.getDocumentViewScrollPane().removeMouseWheelListener((TextSelectionViewHandler)this.currentTool);
            }
        }
        return this.currentTool;
    }

    @Override
    public void installCurrentTool(ToolHandler toolHandler) {
        if (toolHandler != null) {
            toolHandler.installTool();
            this.addMouseListener(toolHandler);
            this.addMouseMotionListener(toolHandler);
            this.currentTool = toolHandler;
        }
    }

    public ToolHandler getCurrentToolHandler() {
        return this.currentTool;
    }

    @Override
    public void setToolMode(int n) {
        this.uninstallCurrentTool();
        JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
        switch (n) {
            case 1: {
                this.currentTool = new PanningHandler(this.documentViewController, this.documentViewModel, this);
                break;
            }
            case 2: {
                this.currentTool = new ZoomInViewHandler(this.documentViewController, this);
                break;
            }
            case 4: {
                this.currentTool = new DynamicZoomHandler(this.documentViewController, jScrollPane);
                break;
            }
            case 5: {
                this.currentTool = new TextSelectionViewHandler(this.documentViewController, this);
                jScrollPane.addMouseWheelListener((TextSelectionViewHandler)this.currentTool);
                break;
            }
            case 6: {
                this.currentTool = new AnnotationSelectionHandler(this.documentViewController, null);
                break;
            }
            default: {
                this.currentTool = null;
            }
        }
        if (this.currentTool != null) {
            this.currentTool.installTool();
            this.addMouseListener(this.currentTool);
            this.addMouseMotionListener(this.currentTool);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.currentTool != null) {
            this.currentTool.paintTool(graphics);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.autoScrollTimer != null && this.autoScrollTimer.isRunning()) {
            this.autoScrollTimer.stop();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.lastMouseLocation = mouseEvent.getPoint();
        if (!this.autoScrollTimer.isRunning()) {
            this.autoScrollTimer.start();
        }
    }

    protected boolean isTextSelectionTool() {
        return this.getCurrentToolHandler() != null && (this.getCurrentToolHandler() instanceof TextSelectionViewHandler || this.getCurrentToolHandler() instanceof TextSelectionPageHandler || this.getCurrentToolHandler() instanceof HighLightAnnotationHandler);
    }

    private boolean autoScrollViewVertical() {
        JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
        if (jScrollPane != null && this.isTextSelectionTool()) {
            JScrollBar jScrollBar;
            JScrollBar jScrollBar2;
            Rectangle rectangle = jScrollPane.getViewport().getViewRect();
            Rectangle rectangle2 = this.getBounds();
            if (rectangle.getY() > 0.0 && (double)this.lastMouseLocation.y < rectangle.getY() && (jScrollBar2 = jScrollPane.getVerticalScrollBar()) != null) {
                jScrollBar2.setValue(jScrollBar2.getValue() - jScrollBar2.getBlockIncrement());
                this.lastMouseLocation.y -= jScrollBar2.getBlockIncrement();
                return true;
            }
            double d = rectangle.getY() + rectangle.getHeight();
            if (d < rectangle2.getHeight() && (double)this.lastMouseLocation.y > d && (jScrollBar = jScrollPane.getVerticalScrollBar()) != null) {
                jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getBlockIncrement());
                this.lastMouseLocation.y += jScrollBar.getBlockIncrement();
                return true;
            }
        }
        return false;
    }

    private boolean autoScrollViewHorizontal() {
        JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
        if (jScrollPane != null && this.isTextSelectionTool()) {
            JScrollBar jScrollBar;
            JScrollBar jScrollBar2;
            Rectangle rectangle = jScrollPane.getViewport().getViewRect();
            Rectangle rectangle2 = this.getBounds();
            if (rectangle.getX() > 0.0 && (double)this.lastMouseLocation.x < rectangle.getX() && (jScrollBar2 = jScrollPane.getHorizontalScrollBar()) != null) {
                jScrollBar2.setValue(jScrollBar2.getValue() - jScrollBar2.getBlockIncrement());
                this.lastMouseLocation.x -= jScrollBar2.getBlockIncrement();
                return true;
            }
            double d = rectangle.getX() + rectangle.getWidth();
            if (d < rectangle2.getWidth() && (double)this.lastMouseLocation.x > d && (jScrollBar = jScrollPane.getHorizontalScrollBar()) != null) {
                jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getBlockIncrement());
                this.lastMouseLocation.x += jScrollBar.getBlockIncrement();
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.autoScrollViewVertical() && !this.autoScrollViewHorizontal()) {
            this.autoScrollTimer.stop();
        }
    }

    private AbstractPageViewComponent isOverPageComponent(MouseEvent mouseEvent) {
        Component component = this.findComponentAt(mouseEvent.getPoint());
        if (component instanceof AbstractPageViewComponent) {
            return (AbstractPageViewComponent)component;
        }
        return null;
    }

    static {
        block5: {
            block4: {
                logger = Logger.getLogger(AbstractDocumentView.class.toString());
                try {
                    String string = Defs.sysProperty((String)"org.icepdf.core.views.background.color", (String)"#808080");
                    int n = ColorUtil.convertColor((String)string);
                    backgroundColour = new Color(n >= 0 ? n : Integer.parseInt("808080", 16));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading page shadow colour");
                }
            }
            try {
                SCROLL_REFRESH_DELAY = Defs.sysPropertyInt((String)"org.icepdf.core.views.autoScroll.interval", (int)10);
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error auto scroll speed value");
            }
        }
    }
}

