/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.signatures;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.acroform.InteractiveForm;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.ri.common.AbstractWorkerPanel;
import org.icepdf.ri.common.utility.signatures.SignatureCellRender;
import org.icepdf.ri.common.utility.signatures.SignatureCertTreeNode;
import org.icepdf.ri.common.utility.signatures.SignatureTreeNode;
import org.icepdf.ri.common.utility.signatures.VerifyAllSignaturesTask;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.PageComponentSelector;
import org.icepdf.ri.common.views.annotations.signatures.CertificatePropertiesDialog;
import org.icepdf.ri.common.views.annotations.signatures.SignaturePropertiesDialog;
import org.icepdf.ri.common.views.annotations.signatures.SignatureValidationDialog;

public class SignaturesHandlerPanel
extends AbstractWorkerPanel {
    private static final Logger logger = Logger.getLogger(SignaturesHandlerPanel.class.toString());

    public SignaturesHandlerPanel(Controller controller) {
        super(controller);
        this.nodeSelectionListener = new NodeSelectionListener();
        this.rootNodeLabel = this.messageBundle.getString("viewer.utilityPane.signatures.tab.title");
        this.cellRenderer = new SignatureCellRender();
        this.buildUI();
    }

    @Override
    public void buildUI() {
        super.buildUI();
        this.buildProgressBar();
    }

    void addSignature(SignatureWidgetAnnotation signatureWidgetAnnotation) {
        SignatureDictionary signatureDictionary;
        if (signatureWidgetAnnotation != null && (signatureDictionary = signatureWidgetAnnotation.getSignatureDictionary()).getEntries().size() > 0) {
            SignatureTreeNode signatureTreeNode = new SignatureTreeNode(signatureWidgetAnnotation, this.messageBundle);
            signatureTreeNode.refreshSignerNode();
            signatureTreeNode.setAllowsChildren(true);
            this.treeModel.insertNodeInto(signatureTreeNode, this.rootTreeNode, this.rootTreeNode.getChildCount());
            this.tree.expandPath(new TreePath(this.rootTreeNode));
        }
    }

    void addUnsignedSignatures(ArrayList<SignatureWidgetAnnotation> arrayList) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.messageBundle.getString("viewer.utilityPane.signatures.tab.certTree.unsigned.label"));
        this.treeModel.insertNodeInto(defaultMutableTreeNode, this.rootTreeNode, this.rootTreeNode.getChildCount());
        for (SignatureWidgetAnnotation signatureWidgetAnnotation : arrayList) {
            SignatureDictionary signatureDictionary = signatureWidgetAnnotation.getSignatureDictionary();
            if (signatureDictionary.getEntries().size() != 0) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(signatureWidgetAnnotation.getFieldDictionary().getPartialFieldName());
            defaultMutableTreeNode2.setAllowsChildren(false);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.tree.expandPath(new TreePath(this.rootTreeNode));
        this.tree.expandPath(new TreePath(defaultMutableTreeNode));
        this.revalidate();
    }

    void updateSignature(SignatureWidgetAnnotation signatureWidgetAnnotation, SignatureTreeNode signatureTreeNode) {
        if (signatureWidgetAnnotation != null) {
            try {
                TreePath treePath = new TreePath(signatureTreeNode.getPath());
                boolean bl = this.tree.isExpanded(treePath);
                signatureTreeNode.validateSignatureNode();
                signatureTreeNode.refreshSignerNode();
                this.treeModel.reload();
                if (bl) {
                    this.tree.expandPath(new TreePath(signatureTreeNode.getPath()));
                }
            }
            catch (SignatureIntegrityException signatureIntegrityException) {
                logger.log(Level.WARNING, "Could not build signature node.", signatureIntegrityException);
            }
        }
    }

    void showSignatureValidationDialog(SignatureWidgetAnnotation signatureWidgetAnnotation) {
        SignatureValidator signatureValidator;
        SignatureFieldDictionary signatureFieldDictionary;
        if (signatureWidgetAnnotation != null && (signatureFieldDictionary = signatureWidgetAnnotation.getFieldDictionary()) != null && (signatureValidator = signatureWidgetAnnotation.getSignatureValidator()) != null) {
            new SignatureValidationDialog(this.controller.getViewerFrame(), this.messageBundle, signatureWidgetAnnotation, signatureValidator).setVisible(true);
        }
    }

    @Override
    public void selectTreeNodeUserObject(Object object) {
    }

    @Override
    protected void buildWorkerTaskUI() {
        InteractiveForm interactiveForm;
        ArrayList arrayList;
        this.stopWorkerTask();
        Document document = this.controller.getDocument();
        if (document != null && document.getCatalog().getInteractiveForm() != null && (arrayList = (interactiveForm = document.getCatalog().getInteractiveForm()).getSignatureFields()).size() > 0) {
            this.progressLabel.setVisible(true);
            this.progressBar.setVisible(true);
            this.workerTask = new VerifyAllSignaturesTask(this.controller, this, this.messageBundle);
            this.workerTask.execute();
        }
    }

    @Override
    public void startProgressControls(int n) {
    }

    @Override
    public void updateProgressControls(int n) {
    }

    @Override
    public void updateProgressControls(int n, String string) {
    }

    @Override
    public void updateProgressControls(String string) {
    }

    @Override
    public void endProgressControls() {
    }

    private class SignaturesPropertiesActionListener
    implements ActionListener {
        protected final JTree tree;

        SignaturesPropertiesActionListener(JTree jTree) {
            this.tree = jTree;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((NodeSelectionListener)SignaturesHandlerPanel.this.nodeSelectionListener).getSignatureTreeNode() != null) {
                SignatureTreeNode signatureTreeNode = ((NodeSelectionListener)SignaturesHandlerPanel.this.nodeSelectionListener).getSignatureTreeNode();
                new SignaturePropertiesDialog(SignaturesHandlerPanel.this.controller.getViewerFrame(), SignaturesHandlerPanel.this.messageBundle, signatureTreeNode.getOutlineItem()).setVisible(true);
            }
        }
    }

    private class SignaturesPageNavigationListener
    implements ActionListener {
        private SignaturesPageNavigationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((NodeSelectionListener)SignaturesHandlerPanel.this.nodeSelectionListener).getSignatureTreeNode() != null) {
                SignatureTreeNode signatureTreeNode = ((NodeSelectionListener)SignaturesHandlerPanel.this.nodeSelectionListener).getSignatureTreeNode();
                SignatureWidgetAnnotation signatureWidgetAnnotation = signatureTreeNode.getOutlineItem();
                PageComponentSelector.SelectAnnotationComponent(SignaturesHandlerPanel.this.controller, (Annotation)signatureWidgetAnnotation);
            }
        }
    }

    private class NodeSelectionListener
    extends AbstractWorkerPanel.NodeSelectionListener {
        private SignatureTreeNode signatureTreeNode;

        private NodeSelectionListener() {
        }

        @Override
        public void setTree(JTree jTree) {
            super.setTree(jTree);
            this.contextMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(SignaturesHandlerPanel.this.messageBundle.getString("viewer.annotation.signature.menu.validateSignature.label"));
            jMenuItem.addActionListener(new validationActionListener());
            this.contextMenu.add(jMenuItem);
            this.contextMenu.add(new JPopupMenu.Separator());
            JMenuItem jMenuItem2 = new JMenuItem(SignaturesHandlerPanel.this.messageBundle.getString("viewer.annotation.signature.menu.signatureProperties.label"));
            jMenuItem2.addActionListener(new SignaturesPropertiesActionListener(jTree));
            this.contextMenu.add(jMenuItem2);
            this.contextMenu.add(new JPopupMenu.Separator());
            JMenuItem jMenuItem3 = new JMenuItem(SignaturesHandlerPanel.this.messageBundle.getString("viewer.annotation.signature.menu.signaturePageNavigation.label"));
            jMenuItem3.addActionListener(new SignaturesPageNavigationListener());
            this.contextMenu.add(jMenuItem3);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof SignatureCertTreeNode) {
                    SignatureCertTreeNode signatureCertTreeNode = (SignatureCertTreeNode)object;
                    new CertificatePropertiesDialog(SignaturesHandlerPanel.this.controller.getViewerFrame(), SignaturesHandlerPanel.this.messageBundle, signatureCertTreeNode.getCertificateChain()).setVisible(true);
                } else if (object instanceof SignatureTreeNode && (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2)) {
                    this.signatureTreeNode = (SignatureTreeNode)object;
                    this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        private SignatureTreeNode getSignatureTreeNode() {
            return this.signatureTreeNode;
        }
    }

    private class validationActionListener
    implements ActionListener {
        private validationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SignatureTreeNode signatureTreeNode = ((NodeSelectionListener)SignaturesHandlerPanel.this.nodeSelectionListener).getSignatureTreeNode();
            SignatureWidgetAnnotation signatureWidgetAnnotation = signatureTreeNode.getOutlineItem();
            try {
                SignaturesHandlerPanel.this.updateSignature(signatureWidgetAnnotation, signatureTreeNode);
                SignaturesHandlerPanel.this.showSignatureValidationDialog(signatureWidgetAnnotation);
                SignaturesHandlerPanel.this.repaint();
            }
            catch (Exception exception) {
                logger.log(Level.FINER, "Error verifying signature.", exception);
            }
            SignaturesHandlerPanel.this.validate();
        }
    }
}

