/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.search.SearchMode;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;

public class SimpleSearchHelper
implements PropertyChangeListener {
    private final Controller controller;
    private final DocumentViewControllerImpl documentViewController;
    private final DocumentSearchController searchController;
    private final String pattern;
    private int currentPage;
    private final int startPage;
    private final int pageCount;
    private int wordHits;
    private int wordIndex;
    private int commentHits;
    private int commentIndex;
    private final SearchMode searchMode;
    private final boolean commentsEnabled;
    private final boolean wholeWord;
    private final boolean caseSensitive;

    private SimpleSearchHelper(Builder builder) {
        this.controller = builder.controller;
        this.searchMode = builder.wholePage ? SearchMode.PAGE : SearchMode.WORD;
        this.pattern = builder.pattern;
        this.wholeWord = builder.wholeWord;
        this.caseSensitive = builder.caseSensitive;
        this.commentsEnabled = builder.comments;
        this.currentPage = this.controller.getCurrentPageNumber();
        this.pageCount = this.controller.getDocument().getNumberOfPages();
        this.documentViewController = (DocumentViewControllerImpl)this.controller.getDocumentViewController();
        this.documentViewController.addPropertyChangeListener(this);
        this.searchController = this.controller.getDocumentSearchController();
        this.clearAll();
        this.startPage = this.currentPage;
        this.searchForward(this.currentPage);
    }

    public void dispose() {
        this.documentViewController.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("documentCurrentPage")) {
            this.currentPage = (Integer)object;
        }
    }

    public void clearAll() {
        this.searchController.clearAllSearchHighlight();
        this.searchController.setSearchMode(this.searchMode);
        this.controller.getDocumentViewController().getViewContainer().repaint();
        this.commentIndex = 0;
        this.commentHits = 0;
        this.wordIndex = 0;
        this.wordHits = 0;
    }

    public void nextResult() {
        if (this.isEndOfPage()) {
            ++this.currentPage;
            if (this.currentPage >= this.pageCount) {
                this.currentPage = 0;
            }
            this.searchForward(this.currentPage);
        } else {
            if (!this.isLastWord()) {
                ++this.wordIndex;
            }
            if (!this.isLastComment()) {
                // empty if block
            }
        }
        this.searchController.nextSearchHit();
    }

    public void previousResult() {
        if (this.isStartOfPage()) {
            --this.currentPage;
            if (this.currentPage >= 0) {
                this.currentPage = this.pageCount - 1;
            }
            this.searchBackwards(this.currentPage);
        } else {
            if (!this.isFirstWord()) {
                --this.wordIndex;
            }
            if (!this.isLastComment()) {
                // empty if block
            }
        }
        this.searchController.previousSearchHit();
    }

    private void searchForward(int n) {
        if (this.commentsEnabled) {
            // empty if block
        }
        this.wordIndex = 0;
        this.currentPage = n;
        this.wordHits = this.searchController.searchHighlightPage(n, this.pattern, this.caseSensitive, this.wholeWord);
        if (this.wordHits == 0) {
            int n2 = this.currentPage + 1;
            if (n2 >= this.pageCount) {
                n2 = 0;
            }
            if (n2 != this.startPage) {
                this.searchForward(n2);
            }
        } else {
            this.controller.getDocumentViewController().getViewContainer().repaint();
        }
    }

    private void searchBackwards(int n) {
        if (this.commentsEnabled) {
            // empty if block
        }
        this.currentPage = n;
        this.wordIndex = this.wordHits = this.searchController.searchHighlightPage(n, this.pattern, this.caseSensitive, this.wholeWord);
        if (this.wordHits == 0) {
            int n2 = this.currentPage - 1;
            if (n2 < 0) {
                n2 = this.pageCount - 1;
            }
            if (n2 != this.startPage) {
                this.searchBackwards(n2);
            }
        } else {
            this.controller.getDocumentViewController().getViewContainer().repaint();
        }
    }

    private boolean isEndOfPage() {
        return this.isLastWord() && this.isLastComment();
    }

    private boolean isStartOfPage() {
        return this.wordIndex == 0 && this.commentIndex == 0;
    }

    private boolean isLastWord() {
        return this.wordIndex >= this.wordHits - 1;
    }

    private boolean isFirstWord() {
        return this.wordIndex <= 0;
    }

    private boolean isLastComment() {
        return this.commentIndex == this.commentHits;
    }

    public static class Builder {
        private final Controller controller;
        private final String pattern;
        private boolean wholePage;
        private boolean wholeWord;
        private boolean caseSensitive;
        private boolean comments;

        public Builder(Controller controller, String string) {
            this.controller = controller;
            this.pattern = string;
        }

        public Builder setWholePage(boolean bl) {
            this.wholePage = bl;
            return this;
        }

        public Builder setWholeWord(boolean bl) {
            this.wholeWord = bl;
            return this;
        }

        public Builder setCaseSensitive(boolean bl) {
            this.caseSensitive = bl;
            return this;
        }

        public Builder setComments(boolean bl) {
            this.comments = bl;
            return this;
        }

        public SimpleSearchHelper build() {
            return new SimpleSearchHelper(this);
        }
    }
}

