/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.search;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.search.BaseSearchModel;
import org.icepdf.ri.common.utility.search.SearchFilterButton;
import org.icepdf.ri.common.utility.search.SearchTextTask;
import org.icepdf.ri.common.utility.search.SimpleSearchHelper;

public class SearchToolBar
extends JToolBar
implements ActionListener,
BaseSearchModel {
    private JLabel searchLabel;
    private JTextField searchTextField;
    private final JButton nextSearchResult;
    private final JButton previousSearchButton;
    private SearchFilterButton searchFilterButton;
    private JMenuItem advancedSearchMenuItem;
    private SimpleSearchHelper simpleSearchHelper;
    private SearchTextTask searchTextTask;
    private final SwingController controller;
    private final ResourceBundle messageBundle;
    private String lastSearchPhrase;

    public SearchToolBar(SwingController swingController, String string, JButton jButton, JButton jButton2) {
        super(string);
        this.controller = swingController;
        this.nextSearchResult = jButton2;
        this.previousSearchButton = jButton;
        this.messageBundle = swingController.getMessageBundle();
        this.buildGui();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        String string = this.searchTextField.getText();
        if (!string.equals(this.lastSearchPhrase)) {
            this.lastSearchPhrase = string;
        }
        if (object == this.advancedSearchMenuItem) {
            this.controller.showSearchPanel(this.lastSearchPhrase);
        } else if (object == this.nextSearchResult && this.simpleSearchHelper != null) {
            this.simpleSearchHelper.nextResult();
        } else if (object == this.previousSearchButton && this.simpleSearchHelper != null) {
            this.simpleSearchHelper.previousResult();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.searchLabel.setEnabled(bl);
        this.searchTextField.setEnabled(bl);
        this.searchFilterButton.setEnabled(bl);
        this.nextSearchResult.setEnabled(bl);
        this.previousSearchButton.setEnabled(bl);
    }

    private void createNewSearch() {
        if (this.simpleSearchHelper != null) {
            this.simpleSearchHelper.dispose();
        }
        this.simpleSearchHelper = this.searchFilterButton.getSimpleSearchHelper(this.controller, this.searchTextField.getText());
    }

    private void createNewFullSearch() {
        if (this.searchTextTask != null && !this.searchTextTask.isCancelled() && !this.searchTextTask.isDone()) {
            this.searchTextTask.cancel(true);
        }
        this.createNewSearch();
        this.controller.getDocumentSearchController().clearAllSearchHighlight();
        this.controller.getDocumentViewController().getViewContainer().repaint();
        this.searchTextField.setForeground(Color.BLACK);
        if (!this.searchTextField.getText().isEmpty()) {
            if (this.searchFilterButton.isRegex()) {
                try {
                    Pattern.compile(this.searchTextField.getText());
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.searchTextField.setForeground(Color.RED);
                    return;
                }
            }
            this.searchTextTask = this.searchFilterButton.getSearchTask(this, this.controller, this.searchTextField.getText());
            this.searchFilterButton.setEnabled(false);
            this.searchTextTask.execute();
        }
    }

    @Override
    public void notifySearchFiltersChanged() {
        this.createNewFullSearch();
    }

    private void buildGui() {
        this.searchLabel = new JLabel(this.messageBundle.getString("viewer.toolbar.tool.search.label"));
        this.searchTextField = new JTextField("", 10);
        this.searchTextField.setToolTipText(this.messageBundle.getString("viewer.toolbar.tool.search.input.tooltip"));
        this.searchTextField.addActionListener(this);
        this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.doUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.doUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.doUpdate();
            }

            private void doUpdate() {
                SearchToolBar.this.createNewFullSearch();
            }
        });
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SearchToolBar.this.nextSearchResult.doClick();
                }
            }
        });
        this.nextSearchResult.addActionListener(this);
        this.previousSearchButton.addActionListener(this);
        this.advancedSearchMenuItem = new JMenuItem(this.messageBundle.getString("viewer.toolbar.search.advancedSearch.label"));
        this.advancedSearchMenuItem.addActionListener(this);
        this.searchFilterButton = new SearchFilterButton(this, this.controller, "viewer.toolbar.tool.search.filter.tooltip");
        this.searchFilterButton.add(this.advancedSearchMenuItem, 0);
        this.add(this.searchLabel);
        this.add(this.searchTextField);
        this.add(this.searchFilterButton);
        this.add(this.previousSearchButton);
        this.add(this.nextSearchResult);
    }

    public void focusTextField() {
        if (this.searchTextField != null) {
            this.searchTextField.requestFocusInWindow();
        }
    }

    public void setSearchText(String string) {
        if (this.searchTextField != null) {
            this.searchTextField.setText(string);
        }
    }

    @Override
    public void updateProgressControls(String string) {
        if (this.searchTextTask.isCancelled() || this.searchTextTask.isDone()) {
            this.searchFilterButton.setEnabled(true);
        }
    }

    @Override
    public void addFoundCommentEntry(SearchTextTask.CommentsResult commentsResult, SearchTextTask searchTextTask) {
    }

    @Override
    public void addFoundOutlineEntry(SearchTextTask.OutlineResult outlineResult, SearchTextTask searchTextTask) {
    }

    @Override
    public void addFoundTextEntry(SearchTextTask.TextResult textResult, SearchTextTask searchTextTask) {
    }

    @Override
    public void addFoundFormsEntry(SearchTextTask.FormsResult formsResult, SearchTextTask searchTextTask) {
    }

    @Override
    public void addFoundDestinationEntry(SearchTextTask.DestinationsResult destinationsResult, SearchTextTask searchTextTask) {
    }

    @Override
    public MessageFormat setupSearchingMessageForm() {
        return null;
    }

    @Override
    public MessageFormat setupSearchResultMessageForm() {
        return null;
    }

    @Override
    public MessageFormat setupSearchCompletionMessageForm() {
        return null;
    }
}

