/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.layers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.OptionalContent;
import org.icepdf.core.pobjects.OptionalContentGroup;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.layers.LayersTree;
import org.icepdf.ri.common.utility.layers.LayersTreeNode;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class LayersPanel
extends JPanel
implements MutableDocument {
    private final SwingController controller;
    protected LayersTreeNode nodes;
    final ResourceBundle messageBundle;

    public LayersPanel(SwingController swingController) {
        super(true);
        this.setFocusable(true);
        this.controller = swingController;
        this.messageBundle = this.controller.getMessageBundle();
    }

    private void buildUI() {
        LayersTree layersTree = new LayersTree(this.nodes);
        layersTree.setShowsRootHandles(true);
        layersTree.setRootVisible(false);
        layersTree.addMouseListener(new NodeSelectionListener(layersTree));
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(layersTree, 22, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.add((Component)jScrollPane, "Center");
    }

    @Override
    public void refreshDocumentInstance() {
        Document document = this.controller.getDocument();
        if (document != null) {
            OptionalContent optionalContent = document.getCatalog().getOptionalContent();
            List list = optionalContent.getOrder();
            if (list != null) {
                boolean bl = optionalContent.getRbGroups() != null && optionalContent.getRbGroups().size() > 0;
                this.nodes = new LayersTreeNode("Layers");
                this.nodes.setAllowsChildren(true);
                this.buildTree(list, this.nodes, bl);
                this.buildUI();
            }
        } else {
            this.removeAll();
        }
    }

    @Override
    public void disposeDocument() {
        this.removeAll();
    }

    public void buildTree(List<Object> list, LayersTreeNode layersTreeNode, boolean bl) {
        LayersTreeNode layersTreeNode2 = null;
        boolean bl2 = true;
        for (Object object : list) {
            LayersTreeNode layersTreeNode3;
            if (object instanceof List) {
                layersTreeNode3 = layersTreeNode.getChildCount() > 0 ? (LayersTreeNode)layersTreeNode.getLastChild() : layersTreeNode;
                this.buildTree((List)object, layersTreeNode3, bl);
                continue;
            }
            if (object instanceof String) {
                if (layersTreeNode2 != null && bl2) {
                    layersTreeNode2.setSelected(true);
                }
                layersTreeNode2 = new LayersTreeNode(object);
                layersTreeNode2.setAllowsChildren(true);
                this.nodes.add(layersTreeNode2);
                bl2 = true;
                continue;
            }
            if (!(object instanceof OptionalContentGroup)) continue;
            layersTreeNode3 = new LayersTreeNode(object);
            layersTreeNode3.setAllowsChildren(true);
            if (bl) {
                layersTreeNode3.setSelectionMode(2);
            }
            layersTreeNode.add(layersTreeNode3);
            if (layersTreeNode3.isSelected()) continue;
            bl2 = false;
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        final JTree tree;

        NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null) {
                LayersTreeNode layersTreeNode = (LayersTreeNode)treePath.getLastPathComponent();
                boolean bl = !layersTreeNode.isSelected();
                layersTreeNode.setSelected(bl);
                DocumentViewController documentViewController = LayersPanel.this.controller.getDocumentViewController();
                DocumentViewModel documentViewModel = documentViewController.getDocumentViewModel();
                List<AbstractPageViewComponent> list = documentViewModel.getPageComponents();
                AbstractPageViewComponent abstractPageViewComponent = list.get(documentViewModel.getViewCurrentPageIndex());
                try {
                    abstractPageViewComponent.getPage().getText().sortAndFormatText();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ((AbstractDocumentView)documentViewController.getDocumentView()).firePropertyChange("documentViewRefreshChange", false, true);
                abstractPageViewComponent.repaint();
                this.tree.repaint();
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(layersTreeNode);
                if (n3 == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }
}

