/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.attachment;

import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.icepdf.core.pobjects.EmbeddedFileStream;
import org.icepdf.core.pobjects.FileSpecification;
import org.icepdf.core.util.Utils;

public class FileTableModel
extends AbstractTableModel {
    public static final int NAME_COLUMN = 0;
    public static final int DESCRIPTION_COLUMN = 1;
    public static final int MODIFIED_COLUMN = 2;
    public static final int SIZE_COLUMN = 3;
    public static final int COMPRESSION_COLUMN = 4;
    public static final int DATA_COLUMN = 5;
    private final String[] columnNames;
    private Object[][] data;

    public FileTableModel(ResourceBundle resourceBundle, HashMap<String, FileSpecification> hashMap) {
        this.columnNames = new String[]{resourceBundle.getString("viewer.utilityPane.attachments.column.fileName.title"), resourceBundle.getString("viewer.utilityPane.attachments.column.description.title"), resourceBundle.getString("viewer.utilityPane.attachments.column.modified.title"), resourceBundle.getString("viewer.utilityPane.attachments.column.size.title"), resourceBundle.getString("viewer.utilityPane.attachments.column.compressedSize.title")};
        if (hashMap != null) {
            Set<String> set = hashMap.keySet();
            int n = set.size();
            int n2 = 6;
            this.data = new Object[n][n2];
            int n3 = 0;
            for (String string : set) {
                FileSpecification fileSpecification = hashMap.get(string);
                EmbeddedFileStream embeddedFileStream = fileSpecification.getEmbeddedFileStream();
                this.data[n3][0] = fileSpecification.getUnicodeFileSpecification() != null ? fileSpecification.getUnicodeFileSpecification() : (fileSpecification.getFileSpecification() != null ? fileSpecification.getFileSpecification() : "");
                this.data[n3][1] = fileSpecification.getDescription() != null ? fileSpecification.getDescription() : "";
                this.data[n3][2] = embeddedFileStream != null && embeddedFileStream.getParamLastModifiedData() != null ? embeddedFileStream.getParamLastModifiedData() : "";
                this.data[n3][3] = embeddedFileStream == null ? "" : Utils.byteFormatter((long)embeddedFileStream.getParamUncompressedSize(), (boolean)true);
                this.data[n3][4] = embeddedFileStream == null ? "" : Utils.byteFormatter((long)embeddedFileStream.getCompressedSize(), (boolean)true);
                this.data[n3][5] = fileSpecification;
                ++n3;
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }
}

