/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;

public class FlagsPanel
extends AnnotationPanelAdapter
implements ItemListener {
    private JComboBox<ValueLabelItem> readOnlyComboBox;
    private JComboBox<ValueLabelItem> noRotateComboBox;
    private JComboBox<ValueLabelItem> noZoomComboBox;
    private JComboBox<ValueLabelItem> printableComboBox;

    public FlagsPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        Annotation annotation = this.currentAnnotationComponent.getAnnotation();
        this.noRotateComboBox.setSelectedIndex(annotation.getFlagNoRotate() ? 0 : 1);
        this.noZoomComboBox.setSelectedIndex(annotation.getFlagNoZoom() ? 0 : 1);
        this.readOnlyComboBox.setSelectedIndex(annotation.getFlagReadOnly() ? 0 : 1);
        this.printableComboBox.setSelectedIndex(annotation.getFlagPrint() ? 0 : 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.noRotateComboBox) {
            this.currentAnnotationComponent.getAnnotation().setFlag(16, this.noRotateComboBox.getSelectedIndex() == 0);
        } else if (itemSelectable == this.noZoomComboBox) {
            this.currentAnnotationComponent.getAnnotation().setFlag(8, this.noZoomComboBox.getSelectedIndex() == 0);
        } else if (itemSelectable == this.readOnlyComboBox) {
            this.currentAnnotationComponent.getAnnotation().setFlag(64, this.readOnlyComboBox.getSelectedIndex() == 0);
        } else if (itemSelectable == this.printableComboBox) {
            this.currentAnnotationComponent.getAnnotation().setFlag(4, this.printableComboBox.getSelectedIndex() == 0);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.noRotateComboBox.setEnabled(bl);
        this.noZoomComboBox.setEnabled(bl);
        this.readOnlyComboBox.setEnabled(true);
        this.printableComboBox.setEnabled(bl);
    }

    private void createGUI() {
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.flags.title"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 2, 1, 2);
        ValueLabelItem[] valueLabelItemArray = new ValueLabelItem[]{new ValueLabelItem(Boolean.TRUE, this.messageBundle.getString("viewer.utilityPane.annotation.flags.enabled")), new ValueLabelItem(Boolean.FALSE, this.messageBundle.getString("viewer.utilityPane.annotation.flags.disabled"))};
        this.noRotateComboBox = new JComboBox<ValueLabelItem>(valueLabelItemArray);
        this.noRotateComboBox.addItemListener(this);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.flags.noRotate")), 0, 0, 1, 1);
        this.addGB(this, this.noRotateComboBox, 1, 0, 1, 1);
        this.noZoomComboBox = new JComboBox<ValueLabelItem>(valueLabelItemArray);
        this.noZoomComboBox.addItemListener(this);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.flags.noZoom")), 0, 1, 1, 1);
        this.addGB(this, this.noZoomComboBox, 1, 1, 1, 1);
        this.readOnlyComboBox = new JComboBox<ValueLabelItem>(valueLabelItemArray);
        this.readOnlyComboBox.addItemListener(this);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.flags.readOnly")), 0, 2, 1, 1);
        this.addGB(this, this.readOnlyComboBox, 1, 2, 1, 1);
        this.printableComboBox = new JComboBox<ValueLabelItem>(valueLabelItemArray);
        this.printableComboBox.addItemListener(this);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.flags.printable")), 0, 3, 1, 1);
        this.addGB(this, this.printableComboBox, 1, 3, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 4, 0, 1);
    }
}

